/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.io;

import emulator.GUI.io.IrqPanel;
import emulator.GUI.io.PortPanel;
import emulator.GUI.io.ShiftPanel;
import emulator.GUI.io.TimerPanel;
import emulator.hardware.io.Via6522;
import emulator.shell.GUI.menu.ViaRegistersDialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Via6522panel
extends JPanel {
    private Via6522 via;
    private TimerPanel timer1panel = new TimerPanel("Timer 1", new String[]{"Timed interrupt on load", "Continuous interrupts", "Timed interrupt on load, one-shot output on PB7", "Continuous interrupts, square wave on PB7"});
    private TimerPanel timer2panel = new TimerPanel("Timer 2", new String[]{"Timed interrupt", "Count-down through PB6"});
    private ShiftPanel shiftpanel = new ShiftPanel("Shift", new String[]{"Disabled", "Shift in under control of T2", "Shift in under control of O2", "Shift in under control of ext. clock", "Shift out free-running at T2 rate", "Shift out under control of T2", "Shift out under control of O2", "Shift out under control of ext. clock"});
    private PortPanel portApanel = new PortPanel("A");
    private PortPanel portBpanel = new PortPanel("B");
    private IrqPanel irqPanel = new IrqPanel();
    private String viaName;

    public Via6522panel(Via6522 via, String viaName) {
        this.via = via;
        this.viaName = viaName;
        this.initPanel();
    }

    public void updateFromVia() {
        this.timer1panel.setLatchValue(this.via.getTimer1Latch());
        this.timer1panel.setTimerValue(this.via.getTimer1Counter());
        this.timer1panel.setModeValue(this.via.getTimer1Mode());
        this.timer2panel.setLatchValue(this.via.getTimer2Latch());
        this.timer2panel.setTimerValue(this.via.getTimer2Counter());
        this.timer2panel.setModeValue(this.via.getTimer2Mode());
        this.shiftpanel.setLatchValue(this.via.getShiftRegister());
        this.shiftpanel.setShiftValue(this.via.getShiftRegister());
        this.shiftpanel.setModeValue(this.via.getShiftMode());
        this.irqPanel.setFlagsValue(this.via.readIFR());
        this.irqPanel.setMaskValue(this.via.readIER());
        this.portApanel.setPortStatus(this.via.getPortA());
        this.portApanel.setPortControlModes(this.via.getCA1Mode(), this.via.getCA2Mode());
        this.portBpanel.setPortStatus(this.via.getPortB());
        this.portBpanel.setPortControlModes(this.via.getCB1Mode(), this.via.getCB2Mode());
    }

    private void initPanel() {
        JPanel regPanel = new JPanel();
        regPanel.setLayout(new BoxLayout(regPanel, 3));
        regPanel.add(this.timer1panel);
        regPanel.add(this.timer2panel);
        regPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        regPanel.add(this.shiftpanel);
        regPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        regPanel.add(this.irqPanel);
        regPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        regPanel.add(Box.createVerticalGlue());
        JButton registersButton = new JButton("Register values...");
        registersButton.addActionListener(new OpenRegistersDialog());
        regPanel.add(registersButton);
        regPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 3));
        portPanel.add(this.portApanel);
        portPanel.add(this.portBpanel);
        this.setLayout(new BoxLayout(this, 2));
        this.add(regPanel);
        this.add(portPanel);
    }

    public class OpenRegistersDialog
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ViaRegistersDialog registersDialog = new ViaRegistersDialog(null, "Registers", Via6522panel.this.viaName);
            int i = 0;
            while (i < 16) {
                try {
                    registersDialog.setRegisterValue(i, Via6522panel.this.via.read(i));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
            registersDialog.setVisible(true);
            if (registersDialog.isResultValid()) {
                i = 0;
                while (i < 16) {
                    try {
                        Via6522panel.this.via.write(i, registersDialog.getRegisterValue(i));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++i;
                }
                Via6522panel.this.updateFromVia();
            }
        }
    }
}

