/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.joystick;

import emulator.hardware.io.peripherals.Joystick;
import emulator.hardware.io.peripherals.JoystickButton;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;

public class VicJoystickCanvas
extends Canvas {
    private JoystickButton fire_pressed;
    private JoystickButton left_pressed;
    private JoystickButton right_pressed;
    private JoystickButton up_pressed;
    private JoystickButton down_pressed;
    private int center_x;
    private int center_y;
    private int inner_a;
    private int inner_b;
    private int outer_a;
    private int outer_b;
    private Rectangle inner_circle;
    private Rectangle left_circle;
    private Rectangle right_circle;
    private Rectangle up_circle;
    private Rectangle down_circle;

    public VicJoystickCanvas(Joystick joystick) {
        this.fire_pressed = joystick.getButton(0);
        this.left_pressed = joystick.getButton(1);
        this.right_pressed = joystick.getButton(2);
        this.up_pressed = joystick.getButton(3);
        this.down_pressed = joystick.getButton(4);
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseHandler());
        joystick.addObserver(new JoystickObserver());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        Rectangle outer_area = this.getBounds();
        outer_area.grow(-5, -5);
        Rectangle inner_area = this.getBounds();
        inner_area.grow(-inner_area.width / 3, -inner_area.height / 3);
        this.inner_circle = (Rectangle)inner_area.clone();
        this.inner_circle.grow(-this.inner_circle.width / 4, -this.inner_circle.height / 4);
        this.left_circle = (Rectangle)this.inner_circle.clone();
        this.left_circle.translate(-inner_area.width, 0);
        this.right_circle = (Rectangle)this.inner_circle.clone();
        this.right_circle.translate(inner_area.width, 0);
        this.up_circle = (Rectangle)this.inner_circle.clone();
        this.up_circle.translate(0, -inner_area.height);
        this.down_circle = (Rectangle)this.inner_circle.clone();
        this.down_circle.translate(0, inner_area.height);
        Stroke save_stroke = g2d.getStroke();
        this.center_x = inner_area.x + inner_area.width / 2;
        this.center_y = inner_area.y + inner_area.height / 2;
        this.inner_a = inner_area.width / 2;
        this.inner_b = inner_area.height / 2;
        this.outer_a = outer_area.width / 2;
        this.outer_b = outer_area.height / 2;
        g2d.setStroke(new BasicStroke(5.0f));
        g2d.drawOval(outer_area.x, outer_area.y, outer_area.width, outer_area.height);
        g2d.drawOval(inner_area.x, inner_area.y, inner_area.width, inner_area.height);
        g2d.setStroke(save_stroke);
        this.drawButtonStates(g2d);
    }

    private void drawButtonStates(Graphics2D g2d) {
        this.drawState(g2d, this.inner_circle, this.fire_pressed.getState());
        this.drawState(g2d, this.left_circle, this.left_pressed.getState());
        this.drawState(g2d, this.right_circle, this.right_pressed.getState());
        this.drawState(g2d, this.up_circle, this.up_pressed.getState());
        this.drawState(g2d, this.down_circle, this.down_pressed.getState());
    }

    private void drawState(Graphics2D g2d, Rectangle rectangle, boolean active) {
        g2d.setColor(active ? Color.GREEN : Color.WHITE);
        g2d.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        g2d.setColor(Color.BLACK);
        g2d.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void handleMousePosition(MouseEvent arg0) {
        double ryo;
        double rxo;
        boolean left_state = false;
        boolean right_state = false;
        boolean up_state = false;
        boolean down_state = false;
        int rx = arg0.getPoint().x - this.center_x;
        double rxi = (double)rx / (double)this.inner_a;
        int ry = arg0.getPoint().y - this.center_y;
        double ryi = (double)ry / (double)this.inner_b;
        if (rxi * rxi + ryi * ryi > 1.0 && (rxo = (double)rx / (double)this.outer_a) * rxo + (ryo = (double)ry / (double)this.outer_b) * ryo < 1.0) {
            if (rx > this.inner_a) {
                right_state = true;
            } else if (rx < -this.inner_a) {
                left_state = true;
            }
            if (ry > this.inner_b) {
                down_state = true;
            } else if (ry < -this.inner_b) {
                up_state = true;
            }
        }
        this.updateButton(left_state, this.left_pressed);
        this.updateButton(right_state, this.right_pressed);
        this.updateButton(up_state, this.up_pressed);
        this.updateButton(down_state, this.down_pressed);
    }

    private void updateButton(boolean state, JoystickButton button) {
        if (state != button.getState()) {
            if (state) {
                button.press();
            } else {
                button.release();
            }
        }
    }

    class JoystickObserver
    implements Observer {
        JoystickObserver() {
        }

        @Override
        public void update(Observable joystick, Object event) {
            VicJoystickCanvas.this.drawButtonStates((Graphics2D)VicJoystickCanvas.this.getGraphics());
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            VicJoystickCanvas.this.fire_pressed.release();
            VicJoystickCanvas.this.left_pressed.release();
            VicJoystickCanvas.this.right_pressed.release();
            VicJoystickCanvas.this.up_pressed.release();
            VicJoystickCanvas.this.down_pressed.release();
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                VicJoystickCanvas.this.fire_pressed.press();
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                VicJoystickCanvas.this.fire_pressed.release();
            }
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            VicJoystickCanvas.this.handleMousePosition(arg0);
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            VicJoystickCanvas.this.handleMousePosition(arg0);
        }
    }
}

