/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.keyboard;

import emulator.GUI.Dimension2D;
import emulator.hardware.io.peripherals.Button;
import emulator.hardware.io.peripherals.KeyboardMatrix;

public class VicKey
implements Button {
    private String caption;
    private boolean is_toggle;
    private double pre_space;
    private Dimension2D<Double> size;
    private KeyboardMatrix matrix;
    private int a_index;
    private int b_index;

    public VicKey(String caption) {
        this.caption = caption;
        this.size = new Dimension2D<Double>(1.0, 1.0);
        this.pre_space = 0.0;
        this.is_toggle = false;
    }

    public VicKey(String caption, double width) {
        this.caption = caption;
        this.size = new Dimension2D<Double>(width, 1.0);
        this.pre_space = 0.0;
        this.is_toggle = false;
    }

    public VicKey(String caption, double width, double pre_space) {
        this.caption = caption;
        this.size = new Dimension2D<Double>(width, 1.0);
        this.pre_space = pre_space;
        this.is_toggle = false;
    }

    public VicKey(String caption, double width, boolean is_toggle) {
        this.caption = caption;
        this.size = new Dimension2D<Double>(width, 1.0);
        this.pre_space = 0.0;
        this.is_toggle = is_toggle;
    }

    public VicKey(String caption, double width, double pre_space, boolean is_toggle) {
        this.caption = caption;
        this.size = new Dimension2D<Double>(width, 1.0);
        this.pre_space = pre_space;
        this.is_toggle = is_toggle;
    }

    public VicKey attachToMatrix(KeyboardMatrix matrix, int a, int b) {
        this.matrix = matrix;
        this.a_index = a;
        this.b_index = b;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean isIsToggle() {
        return this.is_toggle;
    }

    public double getPreSpace() {
        return this.pre_space;
    }

    public Dimension2D<Double> getSize() {
        return this.size;
    }

    @Override
    public void press() {
        if (this.matrix != null) {
            this.matrix.keyDown(this.a_index, this.b_index);
        }
    }

    @Override
    public void release() {
        if (this.matrix != null) {
            this.matrix.keyUp(this.a_index, this.b_index);
        }
    }
}

