/*
 * Decompiled with CFR 0.152.
 */
package emulator.GUI.keyboard;

import emulator.GUI.PersistentFrame;
import emulator.GUI.keyboard.VicKey;
import emulator.GUI.keyboard.VicKeyboard;
import emulator.GUI.keyboard.VicMouseEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.LayoutStyle;

public class VicKeyboardFrame
extends PersistentFrame {
    private int block_width = 50;
    private int block_height = 50;
    private static final long serialVersionUID = 8810260280513032012L;

    public VicKeyboardFrame(String appName, VicKeyboard keyboard) {
        super("Vic Keyboard", appName);
        this.setDefaultCloseOperation(3);
        Font button_font = new Font("SansSerif", 1, 10);
        Insets default_button_frame = new Insets(0, 0, 0, 0);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup lines_down = layout.createSequentialGroup();
        GroupLayout.ParallelGroup lines_right = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        int i = 0;
        while (i < keyboard.getRows()) {
            GroupLayout.ParallelGroup line_hor = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
            GroupLayout.SequentialGroup line_flow = layout.createSequentialGroup();
            int j = 0;
            while (j < keyboard.getCols(i)) {
                VicKey key = keyboard.getKey(i, j);
                if (key.getPreSpace() > 0.0) {
                    line_flow.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, (int)((double)this.block_width * key.getPreSpace()), Short.MAX_VALUE);
                }
                String caption = key.getCaption();
                JButton button = new JButton(this.formatButtonText(caption));
                button.setMargin(default_button_frame);
                button.setPreferredSize(new Dimension((int)((double)this.block_width * key.getSize().getWidth()), (int)((double)this.block_height * key.getSize().getHeight())));
                button.setFont(button_font);
                button.addMouseListener(new VicMouseEvent(button, key));
                line_hor.addComponent(button, -2, -1, -2);
                line_flow.addComponent(button, -2, -1, -2);
                ++j;
            }
            lines_down.addGroup(line_hor);
            lines_right.addGroup(line_flow);
            ++i;
        }
        layout.setVerticalGroup(lines_down);
        layout.setHorizontalGroup(lines_right);
    }

    private String formatButtonText(String caption) {
        if (caption.contains("\n")) {
            String html_caption = "<html><center>";
            int i = 0;
            while (i < caption.length()) {
                html_caption = caption.charAt(i) == '\n' ? String.valueOf(html_caption) + "<p>" : String.valueOf(html_caption) + caption.charAt(i);
                ++i;
            }
            html_caption = String.valueOf(html_caption) + "</center></html>";
            return html_caption;
        }
        return caption;
    }
}

