/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.GUI.VicUI;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.DebugMemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.IllegalOpcodeException;
import java.io.FileInputStream;

public class TestMain {
    public static void main(String[] args) throws Exception {
        Cpu6502 cpu = new Cpu6502();
        DebugMemoryBlock memory = new DebugMemoryBlock(65536);
        memory.loadFromStream(new FileInputStream("data\\characters.901460-03.bin"), 32768, 4096);
        memory.loadFromStream(new FileInputStream("data\\pal.bin"), 49152, 16384);
        memory.enableReadonly(32768, 36863, true);
        memory.enableReadonly(49152, 65535, true);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        VicUI.run();
        try {
            try {
                cpu.reset();
                cpu.run();
            }
            catch (IllegalOpcodeException e) {
                cpu.setPC(cpu.getPC() - 1);
                throw e;
            }
        }
        finally {
            cpu.printState(System.out);
            System.out.println("Run for " + clock.getTicks() + " ticks.");
        }
    }
}

