/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.GUI.VicUI;
import emulator.assembler.Assembler;
import emulator.cbm.basic.BasicHelper;
import emulator.hardware.bus.VideoBus;
import emulator.hardware.io.peripherals.KeyboardMatrix;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.video.Vic6561;
import emulator.shell.DebugShell;
import emulator.shell.GUI.ShellUI;
import emulator.small.Board;
import java.io.FileInputStream;

public class VicSmall {
    public static void main(String[] args) throws Exception {
        MemoryBlock memory = new MemoryBlock(65536);
        memory.loadFromStream(new FileInputStream("data\\characters.901460-03.bin"), 32768, 4096);
        memory.loadFromStream(new FileInputStream("data\\pal.bin"), 49152, 16384);
        BasicHelper.setMemoryBlock(memory);
        Assembler assembler = new Assembler();
        assembler.loadSymbols(new FileInputStream("data\\vicrom.sym"), "System");
        Cpu6502 cpu = new Cpu6502();
        Vic6561 vic = new Vic6561();
        Board board = new Board();
        board.setMemory(memory);
        board.setIrqLines(cpu.getNmiIn(), cpu.getIrqIn());
        cpu.attach(board.getBus(), board.getCpuClock());
        cpu.start();
        vic.attach(new VideoBus(memory), board.getVicClock());
        vic.start();
        ShellUI ui = new ShellUI("Vic20s", cpu, memory, board.getBus(), board.getCpuClock());
        ui.setAssembler(assembler);
        DebugShell shell = new DebugShell(ui.createIn(), ui.createOut(), ui.createErr());
        shell.init(cpu, board.getBus());
        shell.setMemory(memory);
        shell.setMemoryBlock(memory);
        shell.setAssembler(assembler);
        if (args.length > 0) {
            shell.setStartScript(args[0]);
        }
        shell.start();
        KeyboardMatrix matrix = new KeyboardMatrix();
        VicUI.setMatrix(matrix);
        VicUI.setKeyboardMapName("data\\keymap.ini");
        VicUI.setClock(board.getCpuClock());
        VicUI.setCpu(cpu);
        VicUI.run();
    }
}

