/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer;

import emulator.assembler.Instruction;
import emulator.hardware.HwWord;
import java.io.PrintStream;

public class AddressDefinition {
    public static final int TYPE_ZP = 0;
    public static final int TYPE_ADR = 1;
    public static final int TYPE_LOW = 2;
    public static final int TYPE_HIGH = 3;
    private int type;
    private int full_address;
    private Instruction instruction;
    private int instruction_address;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setFullAddress(int full_address) {
        this.full_address = full_address;
    }

    public int getFullAddress() {
        return this.full_address;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstructionAddress(int instruction_address) {
        this.instruction_address = instruction_address;
    }

    public int getInstructionAddress() {
        return this.instruction_address;
    }

    public void print(PrintStream out, String prefix) {
        out.print(String.valueOf(prefix) + this.getTypeName() + "($" + new HwWord((long)this.getFullAddress()) + ") ");
        if (this.getInstruction() != null) {
            this.getInstruction().print(out, " <- ", this.getInstructionAddress());
        }
    }

    public String print(String prefix) {
        String text = String.valueOf(prefix) + this.getTypeName() + "($" + new HwWord((long)this.getFullAddress()) + ") ";
        if (this.getInstruction() != null) {
            text = String.valueOf(text) + this.getInstruction().print(" <- ", this.getInstructionAddress());
        }
        return text;
    }

    public String getTypeName() {
        String result = "???";
        switch (this.getType()) {
            case 1: {
                result = "AD";
                break;
            }
            case 0: {
                result = "ZP";
                break;
            }
            case 2: {
                result = "LO";
                break;
            }
            case 3: {
                result = "HI";
            }
        }
        return result;
    }
}

