/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer.sid;

import emulator.analyzer.AddressDefinition;
import emulator.analyzer.sid.SidInfo;
import emulator.analyzer.util.AddressMapper;
import emulator.analyzer.util.CmpCommand;
import emulator.analyzer.util.CmpCommandMap;
import emulator.analyzer.util.FlowMapper;
import emulator.analyzer.util.RangeRelocation;
import emulator.analyzer.util.RelocationMapper;
import emulator.hardware.HwWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SidImage {
    static Logger logger = LogManager.getLogger((String)SidImage.class.getName());
    private SidInfo sid_info;
    byte[] data;
    private int start_address;
    private int init_address;
    private int exec_address;

    public SidImage(SidInfo sid_info) {
        this.sid_info = sid_info;
        this.data = new byte[sid_info.getBlockSize()];
    }

    public int getBlockSize() {
        return this.data.length;
    }

    public int getStartAddress() {
        return this.start_address;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getInitAddress() {
        return this.init_address;
    }

    public int getExecAddress() {
        return this.exec_address;
    }

    public SidInfo getInfo() {
        return this.sid_info;
    }

    void relink(HashMap<Integer, AddressDefinition> address_map, byte[] sid_data, RangeRelocation code_relocation, RangeRelocation dyn_relocation, int[] dyn_flow, Collection<RangeRelocation> relocations, CmpCommandMap cmp_map) {
        this.data = Arrays.copyOf(sid_data, sid_data.length);
        this.start_address = this.sid_info.getStartAddress() + code_relocation.getOffset();
        this.init_address = this.sid_info.getInitAddress() + code_relocation.getOffset();
        if (code_relocation.getRange().contains(this.sid_info.getExecAddress())) {
            this.exec_address = this.sid_info.getExecAddress() + code_relocation.getOffset();
        } else if (dyn_relocation.getRange().contains(this.sid_info.getExecAddress())) {
            this.exec_address = this.sid_info.getExecAddress() + dyn_relocation.getOffset();
        } else {
            logger.error("Unknown memory area for EXEC $" + new HwWord((long)this.sid_info.getExecAddress()));
        }
        ArrayList<Integer> addresses = new ArrayList<Integer>(address_map.keySet());
        Collections.sort(addresses);
        RelocationMapper code_mapper = new RelocationMapper(-this.sid_info.getStartAddress());
        FlowMapper dyn_mapper = dyn_relocation != null ? new FlowMapper(code_mapper, dyn_flow) : null;
        Relocator reloc = new Relocator(code_relocation, dyn_relocation, relocations, cmp_map, code_mapper, dyn_mapper);
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            AddressDefinition def = address_map.get(address);
            reloc.relocateAddress(address, def, reloc.getRelocationForAddress(def));
        }
    }

    private void printError(String message, int address, AddressDefinition def) {
        logger.error(message);
        logger.error(def.print("   $" + new HwWord((long)address) + ": "));
    }

    public String getTitle() {
        return this.sid_info.getTitle();
    }

    public String getAuthor() {
        return this.sid_info.getAuthor();
    }

    public String getYear() {
        return this.sid_info.getYear();
    }

    class Relocator {
        private RangeRelocation code_relocation;
        private RangeRelocation dyn_relocation;
        private Collection<RangeRelocation> relocations;
        private CmpCommandMap cmp_map;
        private AddressMapper code_mapper;
        private AddressMapper dyn_mapper;

        public Relocator(RangeRelocation code_relocation, RangeRelocation dyn_relocation, Collection<RangeRelocation> relocations, CmpCommandMap cmp_map, AddressMapper code_mapper, AddressMapper dyn_mapper) {
            this.code_relocation = code_relocation;
            this.dyn_relocation = dyn_relocation;
            this.relocations = relocations;
            this.cmp_map = cmp_map;
            this.code_mapper = code_mapper;
            this.dyn_mapper = dyn_mapper;
        }

        private RangeRelocation getRelocationForAddress(AddressDefinition def) {
            RangeRelocation act_relocation = null;
            if (this.code_relocation.getRange().contains(def.getFullAddress())) {
                act_relocation = this.code_relocation;
            } else if (this.dyn_relocation != null && this.dyn_relocation.getRange().contains(def.getFullAddress())) {
                act_relocation = this.dyn_relocation;
            } else {
                for (RangeRelocation relocation : this.relocations) {
                    if (!relocation.getRange().contains(def.getFullAddress())) continue;
                    act_relocation = relocation;
                    break;
                }
            }
            return act_relocation;
        }

        private void relocateAddress(int address, AddressDefinition def, RangeRelocation relocation) {
            if (relocation == null) {
                SidImage.this.printError("Error: Unknown address for relocation $" + new HwWord((long)def.getFullAddress()), address, def);
                return;
            }
            if (def.getFullAddress() + relocation.getOffset() < 0) {
                SidImage.this.printError("Error: Relocation out of range $" + new HwWord((long)(def.getFullAddress() + relocation.getOffset())), address, def);
                return;
            }
            AddressMapper mapper = this.dyn_relocation != null && this.dyn_relocation.getRange().contains(address) ? this.dyn_mapper : this.code_mapper;
            try {
                switch (def.getType()) {
                    case 1: {
                        this.mapValue(mapper, SidImage.this.data, address, def.getFullAddress(), relocation, this.cmp_map, true);
                        this.mapValue(mapper, SidImage.this.data, address + 1, def.getFullAddress(), relocation, this.cmp_map, false);
                        break;
                    }
                    case 2: {
                        this.mapValue(mapper, SidImage.this.data, address, def.getFullAddress(), relocation, this.cmp_map, true);
                        break;
                    }
                    case 3: {
                        this.mapValue(mapper, SidImage.this.data, address, def.getFullAddress(), relocation, this.cmp_map, false);
                        break;
                    }
                    case 0: {
                        if (def.getFullAddress() + relocation.getOffset() > 255) {
                            SidImage.this.printError("Error: ZP address out of range $" + new HwWord((long)(def.getFullAddress() + relocation.getOffset())), address, def);
                            break;
                        }
                        this.mapValue(mapper, SidImage.this.data, address, def.getFullAddress(), relocation, this.cmp_map, true);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                SidImage.this.printError("Memory index out of bounds exception " + e + " new value $" + new HwWord((long)(def.getFullAddress() + relocation.getOffset())), address, def);
            }
        }

        private void mapValue(AddressMapper mapper, byte[] data, int address, int value, RangeRelocation relocation, CmpCommandMap cmp_map, boolean is_low) {
            Collection<CmpCommand> cmps = cmp_map.get(address);
            int new_value = value + relocation.getOffset();
            if (cmps != null) {
                for (CmpCommand cmp : cmps) {
                    AddressDefinition def = new AddressDefinition();
                    def.setFullAddress(cmp.getAddressFromOperand(value, is_low));
                    def.setInstruction(cmp.getInstruction());
                    def.setInstructionAddress(cmp.getLocation());
                    def.setType(is_low ? 2 : 3);
                    this.relocateAddress(cmp.getOperandAddress(), def, relocation);
                }
            }
            if (!is_low) {
                new_value >>= 8;
            }
            mapper.set(data, address, new_value & 0xFF);
        }
    }
}

