/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.Assembler;
import emulator.assembler.Instruction;

public class DataDescription {
    private int address;
    private boolean is_code;
    private boolean is_jump_target;
    private int access_count;
    private int length;

    public DataDescription(int address, int length) {
        assert (length > 0);
        this.address = address;
        this.length = length;
        this.is_code = false;
        this.is_jump_target = false;
        this.access_count = 0;
    }

    public boolean isCode() {
        return this.is_code;
    }

    public void setIsCode(boolean is_code) {
        this.is_code = is_code;
    }

    public boolean isJumpTarget() {
        return this.is_jump_target;
    }

    public void setIsJumpTarget(boolean is_jump_target) {
        this.is_jump_target = is_jump_target;
    }

    public int getAccessCount() {
        return this.access_count;
    }

    public void setAccessCount(int access_count) {
        this.access_count = access_count;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setLength(int length) {
        assert (length > 0);
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public Instruction getInstruction(Assembler assembler, byte[] memory) {
        return assembler.dissambleData(memory, this);
    }
}

