/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware;

import emulator.hardware.HwByte;
import emulator.hardware.HwNumber;

public class HwWord
extends HwNumber {
    public HwWord(HwByte lo, HwByte hi) {
        super(hi.getNumber());
        this.shift(8);
        this.or(lo);
    }

    public HwWord(long number) {
        super(number);
    }

    public HwWord() {
        super(0);
    }

    @Override
    void normalize() {
        this.number &= 0xFFFFL;
    }

    public String toString() {
        String text = Integer.toHexString((int)this.number).toUpperCase();
        while (text.length() < 4) {
            text = "0" + text;
        }
        return text;
    }

    public HwByte hi() {
        return new HwByte(this.getNumber() >> 8);
    }

    public HwByte lo() {
        return new HwByte(this.getNumber() & 0xFFL);
    }
}

