/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bits;

import emulator.hardware.bits.BitCollectorStrategy;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.bits.SharedCollectorBit;

public class BitCollector {
    SharedBit target_bit;
    boolean[] source_bits;
    BitCollectorStrategy bit_strategy;

    public BitCollector(int in_cnt, SharedBit target, BitCollectorStrategy strategy) {
        this.source_bits = new boolean[in_cnt];
        this.target_bit = target;
        this.bit_strategy = strategy;
        this.updateTarget();
    }

    private void updateTarget() {
        this.target_bit.setValue(this.bit_strategy.evaluate(this.source_bits));
    }

    public void setBit(int index, boolean value) {
        this.source_bits[index] = value;
        this.updateTarget();
    }

    public SharedBit getBitAt(int index) {
        return new SharedCollectorBit(this, index);
    }
}

