/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bits;

import emulator.hardware.bits.SharedBit;

public class BitGate
extends SharedBit {
    private SharedBit[] control_bits;
    private boolean closed_state;
    private SharedBit[] output_bits;

    public BitGate(int count, boolean default_output) {
        this.control_bits = new SharedBit[count];
        this.output_bits = new SharedBit[count];
        this.closed_state = default_output;
        int i = 0;
        while (i < count) {
            this.control_bits[i] = new SharedBit();
            this.output_bits[i] = new SharedBit();
            this.output_bits[i].setValue(this.closed_state);
            ++i;
        }
    }

    public SharedBit getOutputBit(int index) {
        return this.output_bits[index];
    }

    public void setOutputBit(int index, SharedBit bit) {
        this.output_bits[index] = bit;
    }

    public SharedBit getControlBit(int index) {
        return this.control_bits[index];
    }

    @Override
    public synchronized boolean getValue() {
        return super.getValue();
    }

    @Override
    public synchronized void setValue(boolean value) {
        super.setValue(value);
        this.updateOutput();
    }

    @Override
    public synchronized void toggle() {
        super.toggle();
        this.updateOutput();
    }

    private void updateOutput() {
        int i = 0;
        while (i < this.control_bits.length) {
            this.output_bits[i].setValue(this.control_bits[i].getValue() ? super.getValue() : this.closed_state);
            ++i;
        }
    }
}

