/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bits;

import emulator.hardware.HwNumber;
import java.util.Observable;

public class SharedBit
extends Observable {
    private boolean value;

    public synchronized void setValue(boolean value) {
        if (this.value != value) {
            this.setChanged();
        }
        this.value = value;
        this.notifyObservers(value);
    }

    public synchronized boolean getValue() {
        return this.value;
    }

    public static void setBits(SharedBit[] bits, int value) {
        HwNumber number = HwNumber.create(value);
        int i = 0;
        while (i < bits.length) {
            bits[i].setValue(number.getBit(i));
            ++i;
        }
    }

    public static int getBits(SharedBit[] bits) {
        HwNumber number = HwNumber.create(0);
        int i = 0;
        while (i < bits.length) {
            number.setBit(i, bits[i].getValue());
            ++i;
        }
        return (int)number.getNumber();
    }

    public synchronized void toggle() {
        this.value = !this.value;
        this.setChanged();
        this.notifyObservers(this.value);
    }
}

