/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bus;

import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import emulator.hardware.bus.NullBus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;

public class VicBus
implements Bus {
    public static final int EMPTY_BLOCK = 0;
    public static final int ROM_BLOCK = 1;
    public static final int RAM_BLOCK = 2;
    private Bus memory;
    private Bus vic;
    private Bus via1;
    private Bus via2;
    private Bus unconnected;
    private Bus io2;
    private Bus io3;
    private int block3k = 0;
    private int block0 = 0;
    private int block1 = 0;
    private int block2 = 0;
    private int block3 = 0;

    public VicBus(Bus memory, Bus vic, Bus via1, Bus via2) {
        this.memory = memory;
        this.vic = vic;
        this.via1 = via1;
        this.via2 = via2;
        this.io2 = this.unconnected = new NullBus();
        this.io3 = this.unconnected;
    }

    public void setIO2(Bus io2) {
        this.io2 = io2;
    }

    public void setIO3(Bus io3) {
        this.io3 = io3;
    }

    @Override
    public synchronized int read(int address) throws BusWatchException, UnmappedMemoryException {
        if (this.isReadableAddress(address)) {
            HwWord local_address = new HwWord();
            try {
                return this.getBus(address, local_address).read((int)local_address.getNumber());
            }
            catch (Exception e) {
                throw new UnmappedMemoryException(new HwWord((long)address));
            }
        }
        return 255;
    }

    @Override
    public synchronized void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        if (this.isWritableAddress(address)) {
            HwWord local_address = new HwWord();
            try {
                this.getBus(address, local_address).write((int)local_address.getNumber(), data);
            }
            catch (BusWatchException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UnmappedMemoryException(new HwWord((long)address));
            }
        }
    }

    private boolean isReadableAddress(int address_word) {
        boolean is_readable = false;
        long address = address_word;
        is_readable = address < 32768L ? (address < 16384L ? (address < 8192L ? (1024L <= address && address < 4096L ? this.block3k != 0 : true) : this.block0 != 0) : (address < 24576L ? this.block1 != 0 : this.block2 != 0)) : (address < 49152L ? (address < 40960L ? true : this.block3 != 0) : true);
        return is_readable;
    }

    private boolean isWritableAddress(int address_word) {
        boolean is_writable = false;
        long address = address_word;
        if (address < 32768L) {
            is_writable = address < 16384L ? (address < 8192L ? (1024L <= address && address < 4096L ? this.block3k == 2 : true) : this.block0 == 2) : (address < 24576L ? this.block1 == 2 : this.block2 == 2);
        } else if (address < 49152L) {
            is_writable = address < 40960L ? address >= 36864L : this.block3 == 2;
        }
        return is_writable;
    }

    private Bus getBus(int n_address, HwWord local_address) {
        Bus bus = this.unconnected;
        local_address.setNumber(n_address);
        if (n_address >= 36864 && n_address < 37888) {
            if (n_address <= 36879) {
                local_address.setNumber(n_address & 0xF);
                bus = this.vic;
            } else {
                local_address.setNumber(n_address & 0xF);
                if ((n_address & 0x10) != 0) {
                    bus = this.via1;
                } else if ((n_address & 0x20) != 0) {
                    bus = this.via2;
                }
            }
        } else {
            bus = n_address >= 38912 && n_address < 39936 ? this.io2 : (n_address >= 39936 && n_address < 40960 ? this.io3 : this.memory);
        }
        return bus;
    }

    public int getBlock3k() {
        return this.block3k;
    }

    public void setBlock3k(int block3k) {
        this.block3k = block3k;
    }

    public int getBlock0() {
        return this.block0;
    }

    public void setBlock0(int block0) {
        this.block0 = block0;
    }

    public int getBlock1() {
        return this.block1;
    }

    public void setBlock1(int block1) {
        this.block1 = block1;
    }

    public int getBlock2() {
        return this.block2;
    }

    public void setBlock2(int block2) {
        this.block2 = block2;
    }

    public int getBlock3() {
        return this.block3;
    }

    public void setBlock3(int block3) {
        this.block3 = block3;
    }
}

