/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import emulator.hardware.clock.BarrierClockHandle;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.TickScales;
import java.util.Observer;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public class BarrierClock
implements Clock {
    private TickScales _tickScales = new TickScales();
    private int _cntClocks = 0;
    private CyclicBarrier _barrier = null;
    private long _systemTicks;

    public void startClock() {
        this._barrier = new CyclicBarrier(this._cntClocks);
        this._tickScales.init();
        this._systemTicks = 0L;
    }

    @Override
    public ClockHandle acquireHandle() {
        if (this._barrier != null) {
            return null;
        }
        return new BarrierClockHandle(this, ++this._cntClocks);
    }

    @Override
    public void releaseHandle(ClockHandle handle) {
        this._barrier = null;
        --this._cntClocks;
    }

    @Override
    public void addClockSpeedObserver(Observer clockSpeedObserver) {
        this._tickScales.addObserver(clockSpeedObserver);
    }

    void tick(int id) throws InterruptedException, BrokenBarrierException {
        this._barrier.await();
        ++this._systemTicks;
        if (this._systemTicks % 1000L == 0L) {
            this._tickScales.measureTicks(this._systemTicks);
        }
    }

    public long getFrequency() {
        return this._tickScales.getClockSpeed();
    }
}

