/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.ClockHandleImpl2;
import emulator.hardware.clock.TickScales;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;

public class ClockImpl2
implements Clock {
    private static final int MEASURE_TICKS_INTERVAL = 1000;
    private static int sncThreshhold = 5;
    private List<ClockHandleImpl2> handles = new LinkedList<ClockHandleImpl2>();
    private int active_handles = 0;
    private long system_ticks = 0L;
    private long lastMeasured = 0L;
    private TickScales tick_scales = new TickScales();

    public ClockImpl2() {
        this.tick_scales.init();
    }

    @Override
    public synchronized ClockHandle acquireHandle() {
        ClockHandleImpl2 handle = new ClockHandleImpl2(this);
        this.handles.add(handle);
        ++this.active_handles;
        return handle;
    }

    @Override
    public void releaseHandle(ClockHandle handle) {
        this.handles.remove(handle);
    }

    public synchronized int getSyncThreshhold() {
        return sncThreshhold;
    }

    public synchronized void setSyncThreshhold(int threshhold) {
        sncThreshhold = threshhold;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void requestTicks(ClockHandleImpl2 handle) {
        --this.active_handles;
        if (ClockImpl2.$assertionsDisabled || this.active_handles >= 0) ** GOTO lbl9
        throw new AssertionError();
lbl-1000:
        // 3 sources

        {
            for (ClockHandleImpl2 handle_i : this.handles) {
                if (!handle_i.grantTicks(ClockImpl2.sncThreshhold)) continue;
                ++this.active_handles;
            }
            this.system_ticks += (long)ClockImpl2.sncThreshhold;
lbl9:
            // 2 sources

            ** while (this.active_handles == 0)
        }
lbl10:
        // 1 sources

        if (this.system_ticks > this.lastMeasured) {
            this.tick_scales.measureTicks(this.system_ticks);
            this.lastMeasured = this.system_ticks + 1000L;
        }
    }

    public long getFrequency() {
        return this.tick_scales.getClockSpeed();
    }

    public synchronized long getTicks() {
        return this.system_ticks;
    }

    @Override
    public void addClockSpeedObserver(Observer observer) {
        this.tick_scales.addObserver(observer);
    }
}

