/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.ClockHandleImplementation;
import emulator.hardware.clock.TickHelper;
import emulator.hardware.clock.TickScales;
import java.util.Observer;

public class ClockImplementation
implements Clock {
    private static int max_handles = 10;
    private static long sync_threshhold = 10L;
    private TickScales tick_scales = new TickScales();
    private TickHelper helper;
    private long[] handle_ticks = null;
    private int act_handles = 0;

    public ClockImplementation() {
        this.tick_scales.init();
        this.handle_ticks = new long[max_handles];
        this.helper = new TickHelper(this.handle_ticks, this.act_handles);
    }

    @Override
    public synchronized ClockHandle acquireHandle() {
        ClockHandleImplementation clock_handle = new ClockHandleImplementation(this);
        int new_handle_id = this.act_handles++;
        this.handle_ticks[new_handle_id] = 0L;
        clock_handle.setHandle(new_handle_id);
        this.helper.setHandleCount(this.act_handles);
        return clock_handle;
    }

    @Override
    public synchronized void releaseHandle(ClockHandle handle) {
        this.handle_ticks[((ClockHandleImplementation)handle).getHandle()] = -1L;
    }

    public long getFrequency() {
        return this.tick_scales.getClockSpeed();
    }

    public long getTicks() {
        return this.handle_ticks[0];
    }

    public synchronized void countTicks(ClockHandleImplementation clock_handle, int ticks_elapsed) {
        int n = clock_handle.getHandle();
        this.handle_ticks[n] = this.handle_ticks[n] + (long)ticks_elapsed;
        this.helper.calcMinMax();
        if (this.helper.getMax() > 0x3FFFFFFFFFFFFFFFL) {
            this.helper.rebaseTicks();
        }
        if (this.helper.getMin() + sync_threshhold < this.handle_ticks[clock_handle.getHandle()]) {
            this.notifyAll();
            try {
                while (this.helper.getMin() + sync_threshhold < this.handle_ticks[clock_handle.getHandle()]) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (clock_handle.getHandle() == 0) {
            this.tick_scales.measureTicks(this.getTicks());
        }
    }

    @Override
    public void addClockSpeedObserver(Observer observer) {
        this.tick_scales.addObserver(observer);
    }
}

