/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import java.util.Observable;

public class TickScales
extends Observable {
    private long counting_interval = 1000000L;
    private long start_time;
    private long clock_speed = 0L;
    private long last_trigger;
    private long next_trigger;

    public void init() {
        this.start_time = System.nanoTime();
        this.advanceTriggerFrom(0L);
    }

    private void advanceTriggerFrom(long ticks) {
        this.last_trigger = ticks;
        this.next_trigger = this.last_trigger + this.counting_interval;
    }

    public void measureTicks(long ticks) {
        if (ticks >= this.next_trigger) {
            long now = System.nanoTime();
            long elapsed = now - this.start_time;
            this.start_time = now;
            this.setClockSpeed((long)((double)(ticks - this.last_trigger) * 1.0E9 / (double)elapsed));
            this.advanceTriggerFrom(ticks);
        }
    }

    public void setClockSpeed(long clock_speed) {
        this.clock_speed = clock_speed;
        this.setChanged();
        this.notifyObservers(clock_speed);
    }

    public long getClockSpeed() {
        return this.clock_speed;
    }
}

