/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.custom;

import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.DebugMemoryFlags;
import emulator.hardware.memory.DebugMemoryInterface;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Fe3Memory
extends MemoryBlock {
    static Logger logger = LogManager.getLogger((String)Fe3Memory.class.getName());
    private static final int SUPER_RAM_MODE = 160;
    private static final int NUM_1K_BLOCKS = 64;
    int[] block1k_offsets_r = new int[64];
    int[] block1k_offsets_w = new int[64];
    boolean[] block1k_readonly = new boolean[64];
    int reg1 = 0;
    int reg2 = 0;

    public Fe3Memory() {
        super(589824);
        this.initMapping();
    }

    private void initMapping() {
        int i = 0;
        while (i < 64) {
            this.setBlockRW(i, i * 1024);
            this.block1k_readonly[i] = false;
            ++i;
        }
    }

    private void set3kToBank0() {
        int i = 1;
        while (i < 4) {
            this.setBlockRW(i, (64 + i) * 1024);
            ++i;
        }
    }

    private void selectBank(int bank) {
        int i = 0;
        while (i < 24) {
            this.setBlockRW(8 + i, (64 + i + bank * 32) * 1024);
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.setBlockRW(40 + i, (88 + i + bank * 32) * 1024);
            ++i;
        }
    }

    private void setBlockRW(int i, int offset) {
        this.block1k_offsets_r[i] = offset;
        this.block1k_offsets_w[i] = offset;
    }

    private void onReg1() {
        switch (this.reg1 & 0xE0) {
            case 160: {
                this.selectBank(this.reg1 & 0x1F);
                break;
            }
            default: {
                logger.warn("FE3 Super RAM mode switched off! (" + this.reg1 + ")");
            }
        }
    }

    private int readRAM(int bus_address) throws UnmappedMemoryException, BusWatchException {
        int address = this.block1k_offsets_r[bus_address / 1024] + (bus_address & 0x3FF);
        return this.read(address);
    }

    private void writeRAM(int bus_address, int data) throws UnmappedMemoryException, BusWatchException {
        int address = this.block1k_offsets_w[bus_address / 1024] + (bus_address & 0x3FF);
        this.write(address, data);
    }

    private void onReg2() {
    }

    public Bus getMemoryBus() {
        return new MemoryBus();
    }

    public Bus getIoBus() {
        return new IoBus();
    }

    public int getReg1() {
        return this.reg1;
    }

    public void setReg1(int reg1) {
        this.reg1 = reg1;
        this.onReg1();
    }

    public int getReg2() {
        return this.reg2;
    }

    public void setReg2(int reg2) {
        this.reg2 = reg2;
        this.onReg2();
    }

    class IoBus
    implements Bus {
        private static final int REG1_ADDRESS = 39938;
        private static final int REG2_ADDRESS = 39939;

        IoBus() {
        }

        @Override
        public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
            if (address == 39938) {
                Fe3Memory.this.setReg1(data);
            } else if (address == 39939) {
                Fe3Memory.this.setReg2(data);
            }
        }

        @Override
        public int read(int address) throws BusWatchException, UnmappedMemoryException {
            if (address == 39938) {
                return Fe3Memory.this.getReg1();
            }
            if (address == 39939) {
                return Fe3Memory.this.getReg2();
            }
            return address >> 8 & 0xFF;
        }
    }

    class MemoryBus
    implements Bus,
    DebugMemoryInterface {
        DebugMemoryFlags[] flags = new DebugMemoryFlags[65536];

        MemoryBus() {
            int i = 0;
            while (i < this.flags.length) {
                this.flags[i] = new DebugMemoryFlags();
                ++i;
            }
        }

        @Override
        public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
            if (address >= this.flags.length) {
                throw new UnmappedMemoryException(new HwWord((long)address));
            }
            if (this.flags[address].isWriteWatch()) {
                throw new BusWatchException("write", new HwWord((long)address));
            }
            if (!this.flags[address].isReadOnly()) {
                Fe3Memory.this.writeRAM(address, data);
            }
        }

        @Override
        public int read(int address) throws BusWatchException, UnmappedMemoryException {
            if (address >= this.flags.length) {
                throw new UnmappedMemoryException(new HwWord((long)address));
            }
            if (this.flags[address].isReadWatch()) {
                throw new BusWatchException("read", new HwWord((long)address));
            }
            return Fe3Memory.this.readRAM(address);
        }

        @Override
        public synchronized void enableReadWatch(int first, int last, boolean enable) {
            int i = first;
            while (i <= last) {
                this.flags[i].setReadWatch(enable);
                ++i;
            }
        }

        @Override
        public synchronized void enableWriteWatch(int first, int last, boolean enable) {
            int i = first;
            while (i <= last) {
                this.flags[i].setWriteWatch(enable);
                ++i;
            }
        }

        @Override
        public void enableReadonly(int first, int last, boolean enable) {
            int i = first;
            while (i <= last) {
                this.flags[i].setReadOnly(enable);
                ++i;
            }
        }
    }
}

