/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug;

import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;

public class WatchWrites
implements Bus {
    Bus core;
    int first;
    int last;

    public WatchWrites(Bus core, HwWord first, HwWord last) {
        this.core = core;
        this.first = (int)first.getNumber();
        this.last = (int)last.getNumber();
    }

    @Override
    public int read(int address) throws UnmappedMemoryException, BusWatchException {
        return this.core.read(address);
    }

    @Override
    public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        if (address >= this.first && address <= this.last) {
            throw new BusWatchException("write", new HwWord((long)address));
        }
        this.core.write(address, data);
    }
}

