/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io;

import emulator.hardware.HwNumber;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Port6522Listener;
import java.util.LinkedList;

public class Port6522 {
    public static final int NUM_PORT_BITS = 8;
    public static final int NUM_CONTROL_BITS = 2;
    private SharedBit[] out_port_bit = new SharedBit[8];
    private SharedBit[] in_port_bit = new SharedBit[8];
    private SharedBit[] control_bit = new SharedBit[2];
    private int mask;
    private LinkedList<Port6522Listener> listener_list = new LinkedList();

    public Port6522() {
        int i = 0;
        while (i < 8) {
            this.out_port_bit[i] = new SharedBit();
            this.out_port_bit[i].setValue(true);
            this.in_port_bit[i] = new SharedBit();
            this.in_port_bit[i].setValue(true);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.control_bit[i] = new SharedBit();
            ++i;
        }
    }

    public SharedBit getOutPortBit(int i) {
        return this.out_port_bit[i];
    }

    public SharedBit getInPortBit(int i) {
        return this.in_port_bit[i];
    }

    public void setOutPortBit(int index, SharedBit bit) {
        this.out_port_bit[index] = bit;
    }

    public void setInPortBit(int index, SharedBit bit) {
        this.in_port_bit[index] = bit;
    }

    public void setControlBit(int index, SharedBit bit) {
        this.control_bit[index] = bit;
    }

    public SharedBit getControlBit(int i) {
        return this.control_bit[i];
    }

    public void setPortMask(int mask) {
        this.mask = mask;
    }

    public int getPortMask() {
        return this.mask;
    }

    public void writePort(int value) {
        HwNumber hw_mask = HwNumber.create(this.mask);
        HwNumber hw_value = HwNumber.create(value);
        int i = 0;
        while (i < 8) {
            if (hw_mask.getBit(i)) {
                this.out_port_bit[i].setValue(hw_value.getBit(i));
            }
            ++i;
        }
    }

    public int readPort() {
        return SharedBit.getBits(this.in_port_bit) & ~this.mask | SharedBit.getBits(this.out_port_bit) & this.mask;
    }

    public void pre() {
        for (Port6522Listener l : this.listener_list) {
            l.handlePre(this);
        }
    }

    public void post() {
        for (Port6522Listener l : this.listener_list) {
            l.handlePost(this);
        }
    }

    public void addPortListener(Port6522Listener port_listener) {
        this.listener_list.add(port_listener);
    }
}

