/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.bits.SerialBit;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.IecPort;

public class SerialPort
implements IecPort {
    private SharedBit serial_srq;
    private SerialBit serial_atn;
    private SerialBit serial_clk;
    private SerialBit serial_data;

    public void attachToVia(Via6522 via_keyboard, Via6522 via_joystick) {
        this.serial_srq = via_keyboard.getPortB().getControlBit(0);
        this.serial_atn = new SerialBit(new SharedBit());
        this.serial_clk = new SerialBit(via_joystick.getPortA().getInPortBit(0));
        this.serial_data = new SerialBit(via_joystick.getPortA().getInPortBit(1));
        via_keyboard.getPortB().setControlBit(0, this.serial_srq);
        via_joystick.getPortA().setOutPortBit(7, this.serial_atn);
        via_keyboard.getPortA().setControlBit(1, this.serial_clk);
        via_keyboard.getPortB().setControlBit(1, this.serial_data);
    }

    @Override
    public boolean getClk() {
        return this.serial_clk.getInBit();
    }

    @Override
    public boolean getData() {
        return this.serial_data.getInBit();
    }

    @Override
    public boolean getAtn() {
        return this.serial_atn.getInBit();
    }

    @Override
    public void setBusData(boolean value) {
        this.serial_data.setBusBit(value);
    }

    @Override
    public void setBusClk(boolean value) {
        this.serial_clk.setBusBit(value);
    }
}

