/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveStatus {
    static Logger logger = LogManager.getLogger((String)DriveStatus.class.getName());
    public static final int OK = 0;
    public static final int SCRATCH_RESULT = 1;
    public static final int READ_ERROR_SYNC = 21;
    public static final int SYNTAX_ERROR = 30;
    public static final int FILE_NOT_OPEN = 61;
    public static final int FILE_NOT_FOUND = 62;
    public static final int DISK_FULL = 72;
    public static final int RESET = 73;
    public static final int NO_DISK = 74;
    private HashMap<Integer, String> text_map = new HashMap();
    private int status = 0;
    private int val1 = 0;
    private int val2 = 0;

    public DriveStatus(String dos_version) {
        this.text_map.put(0, " OK");
        this.text_map.put(1, "FILES SCRATCHED");
        this.text_map.put(21, "READ ERROR");
        this.text_map.put(30, "SYNTAX ERROR");
        this.text_map.put(61, "FILE NOT OPEN");
        this.text_map.put(62, "FILE NOT FOUND");
        this.text_map.put(72, "DISK FULL");
        this.text_map.put(74, "DRIVE NOT READY");
        this.text_map.put(73, dos_version);
    }

    public void setStatus(int status, int val1, int val2) {
        logger.debug("status: " + status + "," + val1 + "," + val2);
        this.status = status;
        this.val1 = val1;
        this.val2 = val2;
    }

    public boolean hasError() {
        return this.status > 1;
    }

    public void clearStatus() {
        this.status = 0;
        this.val1 = 0;
        this.val2 = 0;
        logger.debug("(clear) status: " + this.status + "," + this.val1 + "," + this.val2);
    }

    public int getStatus() {
        return this.status;
    }

    String readStatus() {
        String result = String.valueOf(this.getNumString(this.status)) + ",";
        if (this.text_map.containsKey(this.status)) {
            result = String.valueOf(result) + this.text_map.get(this.status);
        }
        result = String.valueOf(result) + "," + this.getNumString(this.val1) + "," + this.getNumString(this.val2) + "\r";
        return result;
    }

    private String getNumString(int number) {
        return String.valueOf(number < 10 ? "0" : "") + number;
    }
}

