/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.cbm.Petscii;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class FsDirectory {
    private String _relativePath = "";
    private String _currentPath = null;
    private HashMap<String, DirEntry> directory_map = new HashMap();

    public void load(String path, String relativePath) {
        this.unload();
        this._relativePath = relativePath;
        File dir = new File(String.valueOf(path) + "/" + relativePath);
        if (dir.isDirectory()) {
            File[] dir_entries;
            this._currentPath = dir.getAbsolutePath();
            File[] fileArray = dir_entries = dir.listFiles();
            int n = dir_entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                DirEntry dir_entry = new DirEntry(entry);
                while (this.directory_map.containsKey(dir_entry.getCbmName())) {
                    dir_entry.mutateCbmName();
                }
                this.directory_map.put(dir_entry.getCbmName(), dir_entry);
                ++n2;
            }
        }
    }

    public void unload() {
        this._currentPath = null;
        this.directory_map.clear();
    }

    public void getDirectory(ByteBuffer buffer) {
        buffer.clear();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this._currentPath != null) {
            this.readAddress(buffer);
            this.readTitle(buffer);
            for (DirEntry dir_entry : this.directory_map.values()) {
                dir_entry.read(buffer);
            }
            this.readEof(buffer);
        }
    }

    private void readEof(ByteBuffer buffer) {
        buffer.putShort((short)0);
    }

    private void readAddress(ByteBuffer buffer) {
        buffer.putShort((short)1025);
    }

    private void readTitle(ByteBuffer buffer) {
        buffer.putShort((short)257);
        buffer.putShort((short)0);
        buffer.put((byte)18);
        this.putBufferString(buffer, this._relativePath, 16);
        buffer.put((byte)32);
        buffer.put("SFS".getBytes());
        buffer.put((byte)0);
    }

    private void putBufferString(ByteBuffer buffer, String string, int len) {
        buffer.put((byte)34);
        char[] schars = string.toCharArray();
        int i = 0;
        while (i < len) {
            if (i >= schars.length) break;
            buffer.put(Petscii.asc2pet(schars[i]));
            ++i;
        }
        buffer.put((byte)34);
        while (i < len) {
            buffer.put((byte)32);
            ++i;
        }
    }

    public String getFilePath(String cbm_name) {
        DirEntry entry = this.directory_map.get(Petscii.pet2asc(cbm_name));
        return entry != null ? String.valueOf(this._currentPath) + File.separator + entry.getFullName() : null;
    }

    class DirEntry {
        private String full_name;
        private String cbm_name;
        private String type;
        private int blocks;

        public DirEntry(File entry) {
            this.full_name = entry.getName();
            String string = this.cbm_name = this.full_name.length() > 16 ? this.full_name.substring(0, 16) : this.full_name;
            if (entry.isDirectory()) {
                this.type = "DIR";
                this.blocks = 0;
            } else {
                this.type = "PRG";
                this.blocks = (int)(entry.length() + 255L) / 256;
                if (this.blocks > Short.MAX_VALUE) {
                    this.blocks = Short.MAX_VALUE;
                }
            }
        }

        public void read(ByteBuffer buffer) {
            buffer.putShort((short)257);
            buffer.putShort((short)this.getBlocks());
            if (this.getBlocks() < 1000) {
                buffer.put((byte)32);
                if (this.getBlocks() < 100) {
                    buffer.put((byte)32);
                    if (this.getBlocks() < 10) {
                        buffer.put((byte)32);
                    }
                }
            }
            FsDirectory.this.putBufferString(buffer, this.getCbmName(), 16);
            buffer.put((byte)32);
            buffer.put(this.type.getBytes());
            buffer.put((byte)0);
        }

        public void mutateCbmName() {
            char[] name = this.cbm_name.toCharArray();
            int index = 15;
            while (index > 0) {
                if (name[index] < '~') {
                    int n = index;
                    name[n] = (char)(name[n] + '\u0001');
                    this.cbm_name = new String(name);
                    return;
                }
                name[index] = 48;
                --index;
            }
        }

        public String getFullName() {
            return this.full_name;
        }

        public String getCbmName() {
            return this.cbm_name;
        }

        public String getType() {
            return this.type;
        }

        public int getBlocks() {
            return this.blocks;
        }
    }
}

