/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.DeviceInfo;
import emulator.hardware.io.peripherals.iec.IecSimDevice;
import emulator.hardware.io.peripherals.iec.IecSimFilePrinter;
import emulator.hardware.io.peripherals.iec.IecSimFsDriver;
import emulator.hardware.io.peripherals.iec.IecSimNullPrinter;

public class IecSimDeviceFactory {
    public IecSimDevice createDevice(DeviceInfo deviceInfo) {
        if (deviceInfo.isEnabled()) {
            if (deviceInfo.getType().equalsIgnoreCase(DeviceInfo.getDeviceTypes()[1])) {
                if (deviceInfo.getFile().isEmpty() || deviceInfo.getFile().equalsIgnoreCase("(null)")) {
                    return new IecSimNullPrinter();
                }
                return new IecSimFilePrinter(deviceInfo.getFile());
            }
            if (deviceInfo.getType().equalsIgnoreCase(DeviceInfo.getDeviceTypes()[0])) {
                return new IecSimFsDriver(deviceInfo.getFile());
            }
        }
        return null;
    }
}

