/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.io.peripherals.iec.DriveStatus;
import emulator.hardware.io.peripherals.iec.FsDirectory;
import emulator.hardware.io.peripherals.iec.FsDriverChannel;
import emulator.hardware.io.peripherals.iec.FsDriverCmdChannel;
import emulator.hardware.io.peripherals.iec.FsDriverFileChannel;
import emulator.hardware.io.peripherals.iec.IecSim;
import emulator.hardware.io.peripherals.iec.IecSimDevice;
import emulator.util.ByteBufferReader;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IecSimFsDriver
implements IecSimDevice {
    static Logger logger = LogManager.getLogger((String)IecSimFsDriver.class.getName());
    private static final int MAX_CHANNELS = 16;
    private static final int CMD_CHANNEL = 15;
    private static final int NO_CHANNEL = -1;
    private FsDriverChannel[] channels = new FsDriverChannel[16];
    private int _activeChannel = -1;
    private IecSim _iecSim = null;
    private boolean _isInOpen = false;
    private DriveStatus _driveStatus = new DriveStatus("IEC SIM FS DRIVER V0.2");
    private FsDirectory _directory = new FsDirectory();
    private String _dirPath = null;
    private String _relativePath = "";

    public IecSimFsDriver(String dirPath) {
        logger.info("Creating filesystem device for " + dirPath);
        this._dirPath = dirPath;
    }

    public IecSimFsDriver() {
        logger.info("Creating filesystem device for active directory");
        this._dirPath = ".";
    }

    @Override
    public void setIecSim(IecSim iecSim) {
        this._iecSim = iecSim;
        this.resetDevice();
        this._directory.load(this._dirPath, this._relativePath);
    }

    private void resetDevice() {
        logger.entry();
        int i = 0;
        while (i < 16) {
            this.closeChannel(i);
            ++i;
        }
        this.assignChannel(15, new FsDriverCmdChannel(this), true);
        this._activeChannel = -1;
        this._driveStatus.setStatus(73, 0, 0);
    }

    private void closeChannel(int channel_no) {
        logger.debug("Closing channel #" + channel_no);
        if (this.channels[channel_no] != null) {
            this.channels[channel_no].close();
            this.channels[channel_no] = null;
        }
        if (channel_no == this._activeChannel) {
            this._activeChannel = -1;
        }
        if (channel_no == 15) {
            this.assignChannel(channel_no, new FsDriverCmdChannel(this), false);
        }
    }

    private void assignChannel(int channel_no, FsDriverChannel driver_channel, boolean do_open) {
        logger.debug("Assigning channel #" + channel_no + (do_open ? " (open)" : ""));
        this.channels[channel_no] = driver_channel;
        if (do_open) {
            this.channels[channel_no].open("");
        }
    }

    @Override
    public void processCommand(ByteBuffer data) {
        while (data.hasRemaining()) {
            int cmd = ByteBufferReader.getByte(data);
            switch (cmd & 0xF0) {
                case 96: {
                    this.openChannel(cmd & 0xF);
                    break;
                }
                case 224: {
                    this.close(cmd & 0xF);
                    break;
                }
                case 240: {
                    this.open(cmd & 0xF);
                }
            }
        }
    }

    private void open(int channel) {
        logger.debug("Opening #" + channel);
        switch (channel) {
            case 15: {
                this.assignChannel(channel, new FsDriverCmdChannel(this), false);
                break;
            }
            default: {
                this.assignChannel(channel, new FsDriverFileChannel(this), false);
            }
        }
        this.setActiveChannel(channel);
        this._isInOpen = true;
    }

    private void close(int channel) {
        logger.debug("Closing #" + channel);
        this.closeChannel(channel);
    }

    private void openChannel(int channel) {
        logger.debug("Opening channel #" + channel);
        this.setActiveChannel(channel);
        this._isInOpen = false;
    }

    @Override
    public void talk() {
        logger.entry();
        this._iecSim.initSend(this);
    }

    @Override
    public void untalk() {
        logger.entry();
    }

    @Override
    public void processData(ByteBuffer data) {
        if (this._isInOpen) {
            this.getActiveChannel().open(ByteBufferReader.toString(data));
            this._isInOpen = false;
        } else if (this.hasActiveChannel()) {
            this.getActiveChannel().write(data);
        }
    }

    @Override
    public void unlisten() {
        logger.entry();
        this._isInOpen = false;
    }

    @Override
    public void listen() {
        logger.entry();
        this._iecSim.initReceive(this);
    }

    public DriveStatus getDriveStatus() {
        return this._driveStatus;
    }

    @Override
    public int read() {
        logger.entry();
        if (this.hasActiveChannel()) {
            logger.trace("reading from active channel #" + this._activeChannel);
            return this.getActiveChannel().read();
        }
        logger.warn("No active channel for device " + this);
        return -1;
    }

    private boolean hasActiveChannel() {
        return this._activeChannel >= 0 && this.channels[this._activeChannel] != null;
    }

    private FsDriverChannel getActiveChannel() {
        return this.channels[this._activeChannel];
    }

    private void setActiveChannel(int channel) {
        this._activeChannel = channel;
    }

    public FsDirectory getDirectory() {
        return this._directory;
    }

    @Override
    public void rewind(int offset) {
        if (this.hasActiveChannel()) {
            this.getActiveChannel().rewind(offset);
        }
    }

    public void changeDirectory(String dirSpec) {
        if (dirSpec.startsWith(":")) {
            this.doChange(dirSpec.substring(1));
        } else if (dirSpec.startsWith("/")) {
            int lastIndex = dirSpec.lastIndexOf(47);
            String pathPart = dirSpec.substring(1, lastIndex);
            this.changeDirectoryTo(pathPart);
        } else {
            this.doChange(dirSpec);
        }
        this._directory.load(this._dirPath, this._relativePath);
    }

    private void doChange(String path) {
        if (path.startsWith("_")) {
            int tailDir = this._relativePath.lastIndexOf("/");
            this._relativePath = tailDir < 0 ? "" : this._relativePath.substring(0, tailDir);
        } else {
            this.changeDirectoryTo(path);
        }
    }

    private void changeDirectoryTo(String pathPart) {
        String currentPath = pathPart.startsWith("/") ? "" : this._relativePath;
        StringTokenizer tokenizer = new StringTokenizer(pathPart, "/");
        while (tokenizer.hasMoreTokens()) {
            String nextDir = tokenizer.nextToken();
            if (nextDir.isEmpty()) continue;
            File currentFile = new File(String.valueOf(this._dirPath) + "/" + currentPath + "/" + nextDir);
            if (!currentFile.isDirectory()) break;
            currentPath = String.valueOf(currentPath) + "/" + nextDir;
        }
        this._relativePath = currentPath;
    }
}

