/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec.sim;

import emulator.hardware.io.peripherals.IecPort;
import emulator.hardware.io.peripherals.iec.sim.Condition;
import emulator.hardware.io.peripherals.iec.sim.Effect;
import emulator.hardware.io.peripherals.iec.sim.Event;

public class IecWorld {
    public Condition ATN = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this.getAtnIn();
        }
    };
    public Condition CLK = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this.getClkIn();
        }
    };
    public Condition DATA = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this.getDataIn();
        }
    };
    public Condition nATN = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this.getAtnIn();
        }
    };
    public Condition nCLK = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this.getClkIn();
        }
    };
    public Condition nDATA = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this.getDataIn();
        }
    };
    public Condition TALK = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this._doSend;
        }
    };
    public Condition nTALK = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this._doSend;
        }
    };
    public Condition LISTEN = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this._doReceive;
        }
    };
    public Condition nLISTEN = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this._doReceive;
        }
    };
    public Condition TIMEOUT = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this._timer == 0;
        }
    };
    public Condition nTIMEOUT = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this._timer > 0;
        }
    };
    public Condition EOI = new Condition(){

        @Override
        public boolean evaluate() {
            return IecWorld.this._isEoi;
        }
    };
    public Condition nEOI = new Condition(){

        @Override
        public boolean evaluate() {
            return !IecWorld.this._isEoi;
        }
    };
    public Effect PULL_CLK = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._port.setBusClk(false);
        }
    };
    public Effect RELEASE_CLK = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._port.setBusClk(true);
        }
    };
    public Effect PULL_DATA = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._port.setBusData(false);
        }
    };
    public Effect RELEASE_DATA = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._port.setBusData(true);
        }
    };
    public Effect BEGIN_SEND = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._doSend = true;
        }
    };
    public Effect END_SEND = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._doSend = false;
        }
    };
    public Effect BEGIN_RECEIVE = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._doReceive = true;
        }
    };
    public Effect END_RECEIVE = new Effect(){

        @Override
        public void execute() {
            IecWorld.this._doReceive = false;
        }
    };
    public static Event TRUE = new Event(null){

        @Override
        public boolean evaluate() {
            return true;
        }
    };
    private IecPort _port;
    private boolean _doSend;
    private boolean _doReceive;
    private boolean _isEoi;
    private int _timer;
    private int _data;
    private boolean atnIn;
    private boolean clkIn;
    private boolean dataIn;

    public Effect SET_TIMEOUT(int timerValue) {
        return new SetTimer(timerValue);
    }

    public Effect RCV_BIT(int index) {
        return new Receiver(index);
    }

    public Effect SND_BIT(int index) {
        return new Sender(index);
    }

    public Effect SET_EOI(boolean value) {
        return new SetEoi(value);
    }

    public IecWorld(IecPort port) {
        this._port = port;
        this.reset();
    }

    public void reset() {
        this._doSend = false;
        this._doReceive = false;
        this._timer = 0;
    }

    public void tick() {
        if (this._timer > 0) {
            --this._timer;
        }
        this.atnIn = this._port.getAtn();
        this.clkIn = this._port.getClk();
        this.dataIn = this._port.getData();
    }

    public void setDataByte(int data) {
        this._data = data;
    }

    public int getDataByte() {
        return this._data;
    }

    public boolean getAtnIn() {
        return this.atnIn;
    }

    public boolean getClkIn() {
        return this.clkIn;
    }

    public boolean getDataIn() {
        return this.dataIn;
    }

    private class Receiver
    implements Effect {
        private int _index;

        Receiver(int index) {
            this._index = index;
        }

        @Override
        public void execute() {
            if (this._index == 0) {
                IecWorld.this._data = 0;
            }
            if (IecWorld.this._port.getData()) {
                IecWorld iecWorld = IecWorld.this;
                iecWorld._data = iecWorld._data | 1 << this._index;
            }
        }
    }

    private class Sender
    implements Effect {
        private int _index;

        Sender(int index) {
            this._index = index;
        }

        @Override
        public void execute() {
            IecWorld.this._port.setBusData((IecWorld.this._data & 1 << this._index) > 0);
        }
    }

    private class SetEoi
    implements Effect {
        private boolean _eoiValue;

        SetEoi(boolean eoiValue) {
            this._eoiValue = eoiValue;
        }

        @Override
        public void execute() {
            IecWorld.this._isEoi = this._eoiValue;
        }
    }

    private class SetTimer
    implements Effect {
        private int _timerValue;

        SetTimer(int timerValue) {
            this._timerValue = timerValue;
        }

        @Override
        public void execute() {
            IecWorld.this._timer = this._timerValue;
        }
    }
}

