/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502;

import emulator.EmulatorException;
import emulator.hardware.CPU;
import emulator.hardware.CPUEventHandler;
import emulator.hardware.CPUExecutionObserver;
import emulator.hardware.HwByte;
import emulator.hardware.HwNumber;
import emulator.hardware.HwWord;
import emulator.hardware.NoExecutionObserver;
import emulator.hardware.bits.EdgeDetector;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.bus.Bus;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.debug.BreakpointException;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.BreakPoints;
import emulator.hardware.nmos6502.CommandDefinition;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.commands.IllegalOpcodeException;
import emulator.hardware.nmos6502.stack.CpuStack;
import emulator.hardware.nmos6502.stack.StackOverflowException;
import emulator.hardware.nmos6502.stack.StackUnderflowException;
import emulator.support.CpuState;
import emulator.util.SynchronizedFlag;
import java.io.PrintStream;
import java.util.Observer;

public class Cpu6502
extends Thread
implements CPU {
    public static final int NMI_VECTOR = 65530;
    public static final int RESET_VECTOR = 65532;
    public static final int IRQ_VECTOR = 65534;
    private static final int NO_INTERRUPT = -1;
    private SharedBit irq_in = new SharedBit();
    private SharedBit nmi_in = new EdgeDetector(false, false);
    private int pc = 0;
    private HwByte accu = new HwByte();
    private HwByte reg_x = new HwByte();
    private HwByte reg_y = new HwByte();
    Flags6502 flags = new Flags6502();
    private CpuStack stack = new CpuStack();
    private CommandSet commands = new CommandSet();
    private CPUEventHandler handler;
    private CPUExecutionObserver execution_observer = new NoExecutionObserver();
    private BreakPoints breakpoints = new BreakPoints();
    private Bus bus = null;
    private ClockHandle clock = null;
    private boolean run_cont = false;
    private boolean run_once = false;
    private boolean break_on_return = false;
    private boolean internal_inhibit_interrupt = false;
    private int interrupt = 65532;
    private SynchronizedFlag is_running = new SynchronizedFlag();
    private int call_depth;

    @Override
    public void addRunningStateObserver(Observer observer) {
        this.is_running.addObserver(observer);
    }

    public void deleteRunningStateObserver(Observer observer) {
        this.is_running.deleteObserver(observer);
    }

    public CpuStack getStack() {
        return this.stack;
    }

    public void attach(Bus bus, Clock clock) {
        this.bus = bus;
        if (clock != null) {
            this.clock = clock.acquireHandle();
        }
        this.stack.setBus(bus);
    }

    public void detach() {
        this.bus = null;
        this.clock = null;
    }

    public SharedBit getIrqIn() {
        return this.irq_in;
    }

    public SharedBit getNmiIn() {
        return this.nmi_in;
    }

    @Override
    public void irq() throws UnmappedMemoryException, EmulatorException {
        this.interrupt = 65534;
    }

    @Override
    public void nmi() throws UnmappedMemoryException, EmulatorException {
        this.interrupt = 65530;
    }

    @Override
    public void reset() throws EmulatorException {
        this.interrupt = 65532;
        this.stack.setSP(255);
        this.is_running.touch();
    }

    @Override
    public void printState(PrintStream out) throws EmulatorException {
        out.println("PC   AC X  Y  Flags    SP  Stack");
        String flagstr = this.flags.toFlagString();
        out.println(new HwWord((long)this.pc) + " " + this.accu + " " + this.reg_x + " " + this.reg_y + " " + flagstr + " " + this.stack.getSPByte() + ": " + this.stack.topOfStackToString());
        this.printNextOpcode(out);
    }

    public void printNextOpcode(PrintStream out) {
        int pc_safe = this.pc;
        try {
            try {
                int opcode = this.readByte(this.pc);
                CommandDefinition command = this.commands.getCommand(new HwByte((long)opcode));
                Operand operand = command.getOperand();
                ++this.pc;
                String data = new HwByte((long)opcode) + " ";
                int i = 0;
                while (i < 2) {
                    data = i < operand.getByteCount() ? String.valueOf(data) + new HwByte((long)this.readByte(this.pc)) + " " : String.valueOf(data) + "   ";
                    ++this.pc;
                    ++i;
                }
                this.pc -= 2;
                try {
                    operand.init(this);
                }
                catch (UnmappedMemoryException unmappedMemoryException) {
                    // empty catch block
                }
                out.println(String.valueOf(data) + " " + command.getCommand().getName() + " " + operand.getString());
            }
            catch (Exception exception) {
                this.pc = pc_safe;
            }
        }
        finally {
            this.pc = pc_safe;
        }
    }

    @Override
    public synchronized void go() {
        this.run_cont = true;
        this.notifyAll();
    }

    @Override
    public synchronized void step() {
        this.run_once = true;
        this.notifyAll();
    }

    public void next() throws EmulatorException {
        int opcode = this.fetchProgramByte();
        CommandDefinition command = this.commands.getCommand(new HwByte((long)opcode));
        command.getOperand().init(this);
        try {
            this.tick(command.getCycles());
            command.getCommand().execute(this, command.getOperand());
            if (this.logTrace()) {
                this.printState(System.out);
            }
        }
        catch (IllegalOpcodeException e) {
            --this.pc;
            throw new IllegalOpcodeException(new HwWord((long)this.pc), new HwByte((long)opcode));
        }
    }

    public void tick(int count) {
        if (this.clock != null) {
            this.clock.tick(count);
        }
    }

    private boolean logTrace() {
        return false;
    }

    @Override
    public synchronized void halt() {
        this.run_cont = false;
        this.run_once = false;
    }

    public int fetchProgramByte() throws UnmappedMemoryException, BusWatchException {
        return this.readByte(this.pc++);
    }

    public int fetchProgramWord() throws UnmappedMemoryException, BusWatchException {
        int data = this.readWord(this.pc);
        this.pc += 2;
        return data;
    }

    public int readWord(int address) throws UnmappedMemoryException, BusWatchException {
        int word_lo = this.bus.read(address);
        int word_hi = this.bus.read(address + 1);
        return word_lo | word_hi << 8;
    }

    public int readByte(int address) throws UnmappedMemoryException, BusWatchException {
        return this.bus.read(address);
    }

    public void writeByte(int address, int data) throws BusWatchException, UnmappedMemoryException {
        this.bus.write(address, data);
    }

    public HwByte getAccu() {
        return new HwByte(this.accu.getNumber());
    }

    public HwByte getX() {
        return new HwByte(this.reg_x.getNumber());
    }

    public HwByte getY() {
        return new HwByte(this.reg_y.getNumber());
    }

    @Override
    public int getPC() {
        return this.pc;
    }

    public void setAccu(HwByte data) {
        this.accu.setNumber(data.getNumber());
    }

    public void setX(HwByte data) {
        this.reg_x.setNumber(data.getNumber());
    }

    public void setY(HwByte data) {
        this.reg_y.setNumber(data.getNumber());
    }

    public void setPC(int addr) {
        this.pc = addr & 0xFFFF;
    }

    public Flags6502 getFlags() {
        return new Flags6502(this.flags.getNumber());
    }

    public void setFlags(Flags6502 flags) {
        this.flags.setNumber(flags.getNumber());
    }

    public HwByte getSP() {
        return this.stack.getSPByte();
    }

    public void setSP(HwByte sp) {
        this.stack.setSP(sp);
    }

    public void pushAddress(int word, int source) throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        this.stack.pushAddress(word, source);
    }

    public void pushByte(int data, int type) throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        this.stack.pushByte(data, type);
    }

    public int popAddress() throws UnmappedMemoryException, BusWatchException, StackUnderflowException {
        return this.stack.popAddress();
    }

    public int popByte() throws UnmappedMemoryException, BusWatchException, StackUnderflowException {
        return this.stack.popByte();
    }

    public void branch(HwByte disp) throws EmulatorException {
        int displacement = (int)disp.getNumber();
        if (displacement > 127) {
            displacement -= 256;
        }
        this.pc += displacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.is_running.setValue(true);
            try {
                Cpu6502 cpu6502 = this;
                synchronized (cpu6502) {
                    if (!this.run_cont && !this.run_once) {
                        this.clearAllStops();
                        this.is_running.setValue(false);
                        while (!this.run_cont && !this.run_once) {
                            this.wait();
                        }
                    }
                    this.is_running.setValue(true);
                    this.run_once = false;
                }
                this.execution_observer.notifyPreExecute(this);
                if (!this.internal_inhibit_interrupt && this.isInterruptPending()) {
                    this.doInterrupt();
                    this.internal_inhibit_interrupt = true;
                } else {
                    try {
                        this.next();
                    }
                    finally {
                        this.internal_inhibit_interrupt = false;
                    }
                }
                this.execution_observer.notifyPostExecute(this);
                Cpu6502 e = this;
                synchronized (e) {
                    int address = this.getPC();
                    if (this.isBreakpoint(address)) {
                        throw new BreakpointException(address);
                    }
                    continue;
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (Exception e) {
                this.halt();
                if (this.handler == null) continue;
                this.handler.notify(this, e.getMessage());
                continue;
            }
            break;
        }
    }

    public boolean isBreakpoint(int address) {
        return this.breakpoints.checkBreak(address);
    }

    private boolean isInterruptPending() {
        this.evaluateInterruptInputs();
        if (this.interrupt == 65534 && this.flags.getInterrupt()) {
            return false;
        }
        return this.interrupt != -1;
    }

    private void evaluateInterruptInputs() {
        if (this.interrupt != 65532) {
            this.interrupt = this.nmi_in.getValue() ? 65530 : (!this.irq_in.getValue() ? 65534 : -1);
        }
    }

    private void doInterrupt() throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        if (this.interrupt != 65532) {
            this.pushAddress(this.pc, 1);
            this.tick(2);
            this.pushByte((int)this.flags.getNumber(), 4);
            this.tick(1);
        }
        this.flags.setInterrupt(true);
        this.setPC(this.readWord(this.interrupt));
        this.tick(2);
        this.interrupt = -1;
    }

    @Override
    public void waitForHalt() {
        try {
            while (this.run_cont || this.run_once) {
                this.is_running.waitForValue(false);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setEventHandler(CPUEventHandler handler) {
        this.handler = handler;
    }

    @Override
    public synchronized void breakAt(HwNumber address, boolean enable) {
        if (enable) {
            this.breakpoints.addBreak((int)address.getNumber());
        } else {
            this.breakpoints.removeBreak((int)address.getNumber());
        }
    }

    @Override
    public void clearAllStops() {
        this.breakpoints.clearAllStops();
        this.enableBreakOnReturn(false);
    }

    @Override
    public void enableBreakOnReturn(boolean enable) {
        this.break_on_return = enable;
        if (enable) {
            this.call_depth = 1;
        }
    }

    @Override
    public void stopOnceAt(HwNumber address) {
        this.breakpoints.addStop((int)address.getNumber());
    }

    public void checkBreakOnReturn() throws BreakpointException {
        --this.call_depth;
        if (this.break_on_return && this.call_depth == 0) {
            throw new BreakpointException(this.getPC());
        }
    }

    public void notifyCall() {
        ++this.call_depth;
    }

    @Override
    public void stepOver() {
        this.call_depth = 0;
        this.step();
        this.waitForHalt();
        if (this.call_depth > 0) {
            this.enableBreakOnReturn(true);
            this.go();
        }
    }

    @Override
    public void setValue(String name, int value) {
        String name_lower = name.toLowerCase();
        if (name_lower.equals("ac")) {
            this.accu.setNumber(value);
        } else if (name_lower.equals("x")) {
            this.reg_x.setNumber(value);
        } else if (name_lower.equals("y")) {
            this.reg_y.setNumber(value);
        } else if (name_lower.equals("sp")) {
            this.stack.setSP(value);
        } else if (name_lower.equals("pc")) {
            this.setPC(value);
        } else if (name_lower.equals("flags")) {
            this.flags.setNumber(value);
        }
    }

    public boolean isRunning() {
        return this.is_running.getValue();
    }

    @Override
    public long getTicks() {
        if (this.clock != null) {
            return this.clock.getTicks();
        }
        return 0L;
    }

    @Override
    public void setExecutionObserver(CPUExecutionObserver observer) {
        this.execution_observer = observer != null ? observer : new NoExecutionObserver();
    }

    @Override
    public CpuState getCpuState() {
        CpuState cpu_state = new CpuState();
        cpu_state.setValue("A", (int)this.getAccu().getNumber());
        cpu_state.setValue("X", (int)this.getX().getNumber());
        cpu_state.setValue("Y", (int)this.getY().getNumber());
        cpu_state.setValue("SP", (int)this.getSP().getNumber());
        cpu_state.setValue("PC", this.getPC());
        cpu_state.setValue("Flags", (int)this.getFlags().getNumber());
        return cpu_state;
    }
}

