/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502;

import emulator.hardware.HwByte;

public class Flags6502
extends HwByte {
    public static final int BIT_CARRY = 0;
    public static final int BIT_ZERO = 1;
    public static final int BIT_INTERRUPT = 2;
    public static final int BIT_DECIMAL = 3;
    public static final int BIT_BREAK = 4;
    public static final int BIT_OVERFLOW = 6;
    public static final int BIT_NEGATIVE = 7;
    public static final int FLAG_CARRY = 1;
    public static final int FLAG_ZERO = 2;
    public static final int FLAG_INTERRUPT = 4;
    public static final int FLAG_DECIMAL = 8;
    public static final int FLAG_BREAK = 16;
    public static final int FLAG_OVERFLOW = 64;
    public static final int FLAG_NEGATIVE = 128;

    public Flags6502() {
    }

    public Flags6502(long number) {
        super(number);
    }

    public boolean getCarry() {
        return this.getBit(0);
    }

    public void setCarry(boolean value) {
        this.setBit(0, value);
    }

    public boolean getZero() {
        return this.getBit(1);
    }

    public void setZero(boolean value) {
        this.setBit(1, value);
    }

    public boolean getInterrupt() {
        return this.getBit(2);
    }

    public void setInterrupt(boolean value) {
        this.setBit(2, value);
    }

    public boolean getDecimal() {
        return this.getBit(3);
    }

    public void setDecimal(boolean value) {
        this.setBit(3, value);
    }

    public boolean getBreak() {
        return this.getBit(4);
    }

    public void setBreak(boolean value) {
        this.setBit(4, value);
    }

    public boolean getOverflow() {
        return this.getBit(6);
    }

    public void setOverflow(boolean value) {
        this.setBit(6, value);
    }

    public boolean getNegative() {
        return this.getBit(7);
    }

    public void setNegative(boolean value) {
        this.setBit(7, value);
    }

    public void setNZFromValue(HwByte value) {
        this.setBit(1, value.isZero());
        this.setBit(7, value.isNegative());
    }

    public void setNZFromValue(int value) {
        this.setNZFromValue(new HwByte((long)value));
    }

    public String toFlagString() {
        String flagstr = "";
        flagstr = String.valueOf(flagstr) + (this.getNegative() ? "N" : " ");
        flagstr = String.valueOf(flagstr) + (this.getOverflow() ? "V" : " ");
        flagstr = String.valueOf(flagstr) + "-";
        flagstr = String.valueOf(flagstr) + (this.getBreak() ? "B" : " ");
        flagstr = String.valueOf(flagstr) + (this.getDecimal() ? "D" : " ");
        flagstr = String.valueOf(flagstr) + (this.getInterrupt() ? "I" : " ");
        flagstr = String.valueOf(flagstr) + (this.getZero() ? "Z" : " ");
        flagstr = String.valueOf(flagstr) + (this.getCarry() ? "C" : " ");
        return flagstr;
    }

    public void fromFlagString(String flagstr) {
        this.setNumber(0L);
        int i = 0;
        while (i < flagstr.length()) {
            switch (flagstr.charAt(i)) {
                case 'N': 
                case 'n': {
                    this.setNegative(true);
                    break;
                }
                case 'V': 
                case 'v': {
                    this.setOverflow(true);
                    break;
                }
                case 'B': 
                case 'b': {
                    this.setBreak(true);
                    break;
                }
                case 'D': 
                case 'd': {
                    this.setDecimal(true);
                    break;
                }
                case 'I': 
                case 'i': {
                    this.setInterrupt(true);
                    break;
                }
                case 'Z': 
                case 'z': {
                    this.setZero(true);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.setCarry(true);
                }
            }
            ++i;
        }
    }
}

