/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.Accumulator;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class ROR
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        Flags6502 flags = cpu.getFlags();
        HwByte value = operand.getByte();
        boolean carry = value.getBit(0);
        value.shift(-1);
        value.setBit(7, flags.getCarry());
        operand.setByte(value);
        flags.setCarry(carry);
        flags.setNZFromValue(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "ROR";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(106, this, new Accumulator());
        cset.defineCommand(102, this, new ZeroPage(), 4);
        cset.defineCommand(118, this, new ZeroPageX(), 4);
        cset.defineCommand(110, this, new Absolute(), 4);
        cset.defineCommand(126, this, new AbsoluteX(false), 5);
    }
}

