/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class SBC
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        Flags6502 flags = cpu.getFlags();
        int accu_old = (int)cpu.getAccu().getNumber();
        int op_in = (int)operand.getByte().getNumber();
        accu_old = flags.getDecimal() ? this.subDecimal(accu_old, flags, op_in) : this.subBinary(accu_old, flags, op_in);
        cpu.setAccu(new HwByte((long)accu_old));
        cpu.setFlags(flags);
    }

    private int subDecimal(int accu_in, Flags6502 flags, int op_in) {
        int accu = 0;
        int borrow = flags.getCarry() ? 0 : 1;
        int nibble1 = accu_in & 0xF;
        int nibble2 = op_in & 0xF;
        int sum = nibble1 - nibble2 - borrow;
        int n = borrow = sum < 0 ? 1 : 0;
        accu = (sum %= 10) < 0 ? (accu += 10 + sum) : (accu += sum);
        nibble1 = (accu_in & 0xF0) >> 4;
        nibble2 = (op_in & 0xF0) >> 4;
        sum = nibble1 - nibble2 - borrow;
        int n2 = borrow = sum < 0 ? 1 : 0;
        accu = (sum %= 10) < 0 ? (accu += 10 + sum << 4) : (accu += sum << 4);
        flags.setCarry(borrow == 0);
        flags.setNZFromValue(accu);
        flags.setOverflow(false);
        return accu;
    }

    private int subBinary(int accu_in, Flags6502 flags, int op_in) {
        HwByte accu = new HwByte((long)accu_in);
        HwByte op_byte = new HwByte((long)op_in);
        op_byte.not();
        int op = (int)op_byte.getNumber();
        if (accu_in > 127) {
            accu_in -= 256;
        }
        if (op > 127) {
            op -= 256;
        }
        int signed_result = accu_in + op;
        if (flags.getCarry()) {
            ++signed_result;
        }
        int full = (int)(accu.getNumber() + op_byte.getNumber());
        if (flags.getCarry()) {
            ++full;
            op_byte.inc(1);
        }
        op_byte.add(accu);
        flags.setNZFromValue(op_byte);
        flags.setCarry(full > 255);
        flags.setOverflow(signed_result < -128 || signed_result > 127);
        return (int)op_byte.getNumber();
    }

    @Override
    public String getName() {
        return "SBC";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(233, this, new Immediate());
        cset.defineCommand(229, this, new ZeroPage());
        cset.defineCommand(245, this, new ZeroPageX());
        cset.defineCommand(237, this, new Absolute());
        cset.defineCommand(253, this, new AbsoluteX());
        cset.defineCommand(249, this, new AbsoluteY());
        cset.defineCommand(225, this, new IndirectX());
        cset.defineCommand(241, this, new IndirectY());
    }
}

