/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.OperandException;

public abstract class ByteOperand
implements Operand {
    private Cpu6502 cpu;
    private HwWord address;

    void setAddress(HwWord address) {
        this.address = address;
    }

    HwWord getAddress() {
        return this.address;
    }

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        this.cpu = cpu;
    }

    @Override
    public HwByte getByte() throws UnmappedMemoryException, BusWatchException {
        return new HwByte((long)this.cpu.readByte((int)this.address.getNumber()));
    }

    @Override
    public HwWord getWord() throws OperandException {
        throw new OperandException("getWord() on byte operand called", this);
    }

    @Override
    public void setByte(HwByte data) throws BusWatchException, UnmappedMemoryException {
        this.cpu.writeByte((int)this.address.getNumber(), (int)data.getNumber());
    }

    @Override
    public void setWord(HwWord data) throws OperandException {
        throw new OperandException("setWord() on byte operand called", this);
    }

    @Override
    public String getString() throws EmulatorException {
        String result = "?";
        try {
            result = "$" + this.getByte();
        }
        catch (UnmappedMemoryException unmappedMemoryException) {
            // empty catch block
        }
        return result;
    }
}

