/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.OperandException;
import emulator.support.NullOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class Immediate
implements Operand {
    HwByte operand;

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        this.operand = new HwByte((long)cpu.fetchProgramByte());
    }

    @Override
    public HwByte getByte() {
        return this.operand;
    }

    @Override
    public HwWord getWord() throws OperandException {
        throw new OperandException("getWord() on immediate operand called", this);
    }

    @Override
    public void setByte(HwByte data) throws OperandException {
        throw new OperandException("setByte() on immediate operand called", this);
    }

    @Override
    public void setWord(HwWord data) throws OperandException {
        throw new OperandException("setWord() on immediate operand called", this);
    }

    @Override
    public String getString() {
        return "#$" + this.operand;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "#$" + new HwByte((long)mem_ref.getByteOp());
    }

    @Override
    public int getExtraCycles() {
        return 0;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new NullOperandEval();
    }
}

