/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.IndirectXOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectX
extends ByteOperand {
    HwByte zp_addr = new HwByte();

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        int full_addr = cpu.fetchProgramByte();
        this.zp_addr.setNumber(full_addr);
        full_addr = (int)((long)full_addr + cpu.getX().getNumber() & 0xFFL);
        this.setAddress(new HwWord((long)cpu.readWord(full_addr)));
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public String getString() {
        return "($" + this.zp_addr + ",X)";
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "(" + symbols.getLabelOrAddress(mem_ref.getByteOp()) + ",X)";
    }

    @Override
    public int getExtraCycles() {
        return 4;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new IndirectXOperandEval(mem_ref);
    }
}

