/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.operands.ByteOperand;
import emulator.support.OperandEval;
import emulator.support.ZeroPageXOperandEval;
import emulator.util.MemoryPtr;

public class ZeroPageX
extends ByteOperand {
    private HwByte zp_addr = new HwByte();

    @Override
    public void init(Cpu6502 cpu) throws UnmappedMemoryException, BusWatchException {
        super.init(cpu);
        HwByte addr = new HwByte((long)cpu.fetchProgramByte());
        this.zp_addr.setNumber(addr.getNumber());
        addr.add(cpu.getX());
        this.setAddress(new HwWord(addr.getNumber()));
    }

    @Override
    public String getString() {
        return "$" + this.zp_addr + ",X";
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return String.valueOf(symbols.getLabelOrAddress(mem_ref.getByteOp())) + ",X";
    }

    @Override
    public int getExtraCycles() {
        return 2;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new ZeroPageXOperandEval(mem_ref);
    }
}

