/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.stack;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.stack.StackData;
import emulator.hardware.nmos6502.stack.StackEntry;
import emulator.hardware.nmos6502.stack.StackOverflowException;
import emulator.hardware.nmos6502.stack.StackUnderflowException;
import java.util.Observable;

public class CpuStack
extends Observable {
    private static final int STACK_BASE = 256;
    public static final int STACK_SIZE = 256;
    public static final Integer PUSH_ADDRESS_EVENT = 1;
    public static final Integer POP_ADDRESS_EVENT = 2;
    private Bus bus = null;
    private StackData[] stack_data = new StackData[256];
    private int sp;

    public CpuStack() {
        int i = 0;
        while (i < 256) {
            this.stack_data[i] = new StackData();
            ++i;
        }
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public int getSP() {
        return this.sp;
    }

    public HwByte getSPByte() {
        return new HwByte((long)this.sp);
    }

    public void setSP(int sp) {
        this.sp = sp & 0xFF;
        this.setChanged();
        this.notifyObservers();
    }

    public void setSP(HwByte sp) {
        this.sp = (int)sp.getNumber();
        this.setChanged();
        this.notifyObservers();
    }

    public void pushAddress(int word, int source) throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        this.setCurrentSource(source);
        this.push(word >> 8 & 0xFF, 3);
        this.push(word & 0xFF, 2);
        this.setChanged();
        this.notifyObservers(PUSH_ADDRESS_EVENT);
    }

    public void pushByte(int data, int type) throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        this.setCurrentSource(0);
        this.push(data, type);
    }

    public int popAddress() throws UnmappedMemoryException, BusWatchException, StackUnderflowException {
        int lo = this.pop();
        int hi = this.pop();
        this.setChanged();
        this.notifyObservers(POP_ADDRESS_EVENT);
        return lo | hi << 8;
    }

    public int popByte() throws UnmappedMemoryException, BusWatchException, StackUnderflowException {
        return this.pop();
    }

    private void push(int data, int type) throws BusWatchException, UnmappedMemoryException, StackOverflowException {
        if (this.sp == 0) {
            throw new StackOverflowException();
        }
        this.setCurrentType(type);
        this.bus.write(256 + this.sp, data);
        this.setSP(this.sp - 1);
    }

    private int pop() throws BusWatchException, UnmappedMemoryException, StackUnderflowException {
        if (this.sp == 255) {
            throw new StackUnderflowException();
        }
        this.setSP(this.sp + 1);
        return this.bus.read(256 + this.sp);
    }

    private void setCurrentType(int type) {
        this.stack_data[this.sp].setType(type);
    }

    private void setCurrentSource(int source) {
        this.stack_data[this.sp].setSource(source);
    }

    public String topOfStackToString() throws EmulatorException {
        String result = "";
        try {
            int sp_adr = 256 + this.sp + 1;
            int i = 0;
            while (i < 6 && sp_adr < 512) {
                result = String.valueOf(result) + new HwByte((long)this.bus.read(sp_adr)) + " ";
                ++i;
                ++sp_adr;
            }
        }
        catch (UnmappedMemoryException e) {
            result = String.valueOf(result) + "??";
        }
        return result;
    }

    public int countEntries() {
        int count = 0;
        int i = this.sp + 1;
        while (i < 256) {
            if (this.stack_data[i].getType() != 2) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public StackEntry[] getContents() throws EmulatorException {
        StackEntry[] result = new StackEntry[this.countEntries()];
        int current_index = 0;
        int address = 0;
        int i = this.sp + 1;
        while (i < 256) {
            if (this.stack_data[i].getType() == 2) {
                address = this.bus.read(256 + i);
            } else {
                result[current_index++] = this.stack_data[i].getType() == 3 ? new StackEntry(i - 1, this.stack_data[i].getSource(), new HwWord((long)(address | this.bus.read(256 + i) << 8))) : (this.stack_data[i].getType() == 4 ? new StackEntry(i, this.stack_data[i].getSource(), new Flags6502((long)this.bus.read(256 + i))) : new StackEntry(i, this.stack_data[i].getSource(), new HwByte((long)this.bus.read(256 + i))));
            }
            ++i;
        }
        assert (current_index == result.length);
        return result;
    }

    public int countFrames() {
        int count = 0;
        int i = this.sp + 1;
        while (i < 256) {
            if (this.stack_data[i].getSource() != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

