/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.video;

import emulator.EmulatorException;
import emulator.GUI.display.VicDisplay;
import emulator.GUI.display.VicDisplayRegistry;
import emulator.hardware.bus.Bus;
import emulator.hardware.bus.VideoBus;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.video.Vic6561ParameterCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Vic6561
extends Thread
implements Bus {
    static Logger logger = LogManager.getLogger((String)Vic6561.class.getName());
    private static final int full_screen_width = 284;
    private static final int full_screen_height = 312;
    static final int horizontal_blank = 32;
    static final int vertical_blank = 40;
    private int[] registers = new int[16];
    private Bus bus = null;
    private ClockHandle clock = null;
    private Vic6561ParameterCache parameter_cache = new Vic6561ParameterCache();
    private int[] multicolor_map = new int[4];

    public Vic6561() {
        int[] nArray = new int[16];
        nArray[0] = 12;
        nArray[1] = 38;
        nArray[2] = 150;
        nArray[3] = 174;
        nArray[5] = 240;
        nArray[7] = 1;
        nArray[8] = 255;
        nArray[9] = 255;
        nArray[15] = 27;
        int[] defaults = nArray;
        int i = 0;
        while (i < 16) {
            this.registers[i] = defaults[i];
            ++i;
        }
        this.updateRegisterCache();
    }

    public void attach(Bus bus, Clock clock) {
        this.bus = bus;
        if (clock != null) {
            this.clock = clock.acquireHandle();
        }
    }

    public void detach() {
        this.bus = null;
        this.clock = null;
    }

    @Override
    public int read(int address) throws BusWatchException, UnmappedMemoryException {
        return this.registers[address & 0xF];
    }

    @Override
    public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        this.registers[address & 0xF] = data & 0xFF;
        this.updateRegisterCache();
    }

    @Override
    public void run() {
        VicDisplay display = VicDisplayRegistry.waitDisplay("VicScreen");
        while (true) {
            try {
                while (true) {
                    this.refreshDisplay(display);
                    display.showScreen();
                }
            }
            catch (EmulatorException ex) {
                logger.error("Emulator exception", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public void refreshDisplay(VicDisplay display) throws EmulatorException {
        byte[] memory = ((VideoBus)this.bus).getMemory();
        int scan_line = 0;
        while (scan_line < 40) {
            this.setRasterCount(scan_line);
            this.clock.tick(71);
            ++scan_line;
        }
        int i = 0;
        while (i < 260) {
            this.setRasterCount(scan_line++);
            this.drawRasterLineDirect(display, memory, i);
            ++i;
        }
        while (scan_line < 312) {
            this.setRasterCount(scan_line);
            this.clock.tick(71);
            ++scan_line;
        }
    }

    private void drawRasterLineDirect(VicDisplay display, byte[] memory, int line) throws EmulatorException {
        this.clock.tick(8);
        int last_line = this.getLastLine();
        if (line >= this.parameter_cache.getFirstLine() && line < last_line) {
            int start_col = 0;
            int pix = 0;
            int frame_width = this.parameter_cache.getLineStart();
            if (frame_width > 0) {
                int frame_left = frame_width & 0xFFFC;
                int frame_rem = frame_width & 3;
                while (pix < frame_left) {
                    this.clock.tick();
                    display.putPixel(pix, line, this.parameter_cache.getFrameColour(), 4);
                    pix += 4;
                }
                if (frame_rem > 0) {
                    this.clock.tick();
                    display.putPixel(pix, line, this.parameter_cache.getFrameColour(), frame_rem);
                    pix += frame_rem;
                }
            } else {
                start_col = -frame_width / 8;
            }
            int next_tick_trigger = 4 - (pix & 3) & 3;
            int col = start_col;
            while (col < this.parameter_cache.getColumns() && pix < 208) {
                this.clock.tick(2);
                int line_offset = line - this.parameter_cache.getFirstLine();
                if (line_offset < 0) {
                    display.putPixel(pix, line, this.parameter_cache.getFrameColour(), 8);
                    pix += 8;
                } else {
                    int mask;
                    int row = line_offset / this.parameter_cache.getCharHeight();
                    int ch_row = line_offset % this.parameter_cache.getCharHeight();
                    int offset = row * this.parameter_cache.getColumns() + col;
                    int code = memory[offset + this.parameter_cache.getVideoRamAddress()] & 0xFF;
                    int color = memory[offset + this.parameter_cache.getColourRamAddress()] & 0xFF;
                    int ch_base = this.parameter_cache.getCharRomAddress() + code * this.parameter_cache.getCharHeight();
                    int ch_addr = ch_base + ch_row;
                    if (ch_addr >= 8192 && ch_addr < 32768) {
                        ch_addr += 24576;
                    }
                    int value = memory[ch_addr] & 0xFF;
                    if ((color & 8) == 0) {
                        mask = 128;
                        int p = Math.min(7, 208 - pix);
                        while (p >= 0) {
                            boolean pixel_set = (value & mask) != 0;
                            display.putPixel(pix++, line, pixel_set == this.parameter_cache.getColourMode() ? color & 7 : this.parameter_cache.getBackgroundColour());
                            mask >>= 1;
                            --p;
                        }
                    } else {
                        mask = 192;
                        this.multicolor_map[2] = color & 7;
                        int bit_pos = 6;
                        while (bit_pos >= 0 && pix < 208) {
                            int color_index = (value & mask) >> bit_pos;
                            display.putPixel(pix, line, this.multicolor_map[color_index], 2);
                            pix += 2;
                            mask >>= 2;
                            bit_pos -= 2;
                        }
                    }
                }
                ++col;
            }
            if (next_tick_trigger > 0) {
                display.putPixel(pix, line, this.parameter_cache.getFrameColour(), next_tick_trigger);
                pix += next_tick_trigger;
            }
            while (pix < 208) {
                this.clock.tick();
                display.putPixel(pix, line, this.parameter_cache.getFrameColour(), 4);
                pix += 4;
            }
        } else {
            int pix = 0;
            while (pix < 208) {
                this.clock.tick();
                display.putPixel(pix, line, this.parameter_cache.getFrameColour(), 4);
                pix += 4;
            }
        }
        this.clock.tick(11);
    }

    private int getLastLine() {
        return this.parameter_cache.getFirstLine() + this.parameter_cache.getRows() * this.parameter_cache.getCharHeight();
    }

    private void setRasterCount(int line) {
        this.registers[3] = (line & 1) != 0 ? this.registers[3] | 0x80 : this.registers[3] & 0x7F;
        this.registers[4] = line >> 1 & 0xFF;
    }

    private void updateRegisterCache() {
        this.parameter_cache.update(this.registers);
        this.multicolor_map[0] = this.parameter_cache.getBackgroundColour();
        this.multicolor_map[1] = this.parameter_cache.getFrameColour();
        this.multicolor_map[3] = this.parameter_cache.getFourthColour();
    }

    public Vic6561ParameterCache getParameterObject() {
        return this.parameter_cache;
    }
}

