/*
 * Decompiled with CFR 0.152.
 */
package emulator.history;

import emulator.history.BitStateChange;

public class BitStateHistory {
    private BitStateChange[] buffer;
    private int head;
    private int tail;

    public BitStateHistory(int bufSize) {
        this.buffer = new BitStateChange[bufSize + 1];
        this.head = 0;
        this.tail = 0;
    }

    public synchronized void add(BitStateChange bitStateChange) throws IllegalArgumentException {
        if (!this.isEmpty()) {
            BitStateChange lastElement = this.buffer[this.advance(this.head, -1)];
            if (lastElement.getTick() > bitStateChange.getTick()) {
                throw new IllegalArgumentException("Time warp detected");
            }
            if (lastElement.getValue() == bitStateChange.getValue()) {
                throw new IllegalArgumentException("State did not change");
            }
        }
        this.buffer[this.head] = bitStateChange;
        this.head = this.advance(this.head, 1);
        if (this.head == this.tail) {
            this.tail = this.advance(this.tail, 1);
        }
    }

    private int advance(int index, int count) {
        int newIndex = (index + count) % this.buffer.length;
        return newIndex < 0 ? newIndex + this.buffer.length : newIndex;
    }

    private BitStateChange at(int pos) {
        return this.buffer[this.advance(this.tail, pos)];
    }

    private int getCount() {
        return this.advance(this.head, -this.tail);
    }

    private boolean isEmpty() {
        return this.head == this.tail;
    }

    public synchronized BitStateChange[] getRange(long firstTick, long lastTick) {
        int rangeSize;
        int rangeStart;
        if (!this.isEmpty() && (rangeStart = this.getGreaterOrEqualIndex(firstTick)) >= 0 && (rangeSize = this.getLessOrEqualIndex(lastTick) - rangeStart + 1) > 0) {
            BitStateChange[] result = new BitStateChange[rangeSize];
            int i = 0;
            while (i < rangeSize) {
                result[i] = this.at(rangeStart + i);
                ++i;
            }
            return result;
        }
        return new BitStateChange[0];
    }

    public synchronized BitStateChange getGreaterOrEqualElement(long tick) {
        int index = this.getGreaterOrEqualIndex(tick);
        return index < 0 ? null : this.at(index);
    }

    public int getGreaterOrEqualIndex(long tick) {
        if (!this.isEmpty()) {
            int firstIndex = 0;
            if (this.at(firstIndex).getTick() >= tick) {
                return 0;
            }
            int lastIndex = this.getCount() - 1;
            if (this.at(lastIndex).getTick() >= tick) {
                while (firstIndex < lastIndex) {
                    int middle = (firstIndex + lastIndex) / 2;
                    if (this.at(middle).getTick() < tick) {
                        firstIndex = middle + 1;
                        continue;
                    }
                    lastIndex = middle;
                }
                return firstIndex;
            }
        }
        return -1;
    }

    public synchronized BitStateChange getLessOrEqualElement(long tick) {
        int index = this.getLessOrEqualIndex(tick);
        return index < 0 ? null : this.at(index);
    }

    public int getLessOrEqualIndex(long tick) {
        if (!this.isEmpty()) {
            int lastIndex = this.getCount() - 1;
            if (this.at(lastIndex).getTick() <= tick) {
                return lastIndex;
            }
            int firstIndex = 0;
            if (this.at(firstIndex).getTick() <= tick) {
                while (firstIndex < lastIndex) {
                    int middle = (firstIndex + lastIndex + 1) / 2;
                    if (this.at(middle).getTick() > tick) {
                        lastIndex = middle - 1;
                        continue;
                    }
                    firstIndex = middle;
                }
                return firstIndex;
            }
        }
        return -1;
    }
}

