/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI;

import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.ConsoleFrame;
import emulator.shell.GUI.menu.WindowConfiguration;
import emulator.shell.GUI.menu.WindowDebug;
import emulator.shell.GUI.menu.WindowIEC;
import emulator.shell.GUI.menu.WindowMemory;
import emulator.shell.GUI.menu.WindowSettings;
import emulator.shell.GUI.menu.WindowVia;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WindowData
implements Observer {
    static Logger logger = LogManager.getLogger((String)WindowData.class.getName());
    private WindowManager window_manager;
    private ImageIcon menu_selected_icon;
    private ImageIcon menu_unselected_icon;
    private HashMap<Integer, JMenuItem> window_menu_map;
    private ConsoleFrame console;
    public static final int WINDOW_ID_MEMORY = 1;
    public static final int WINDOW_ID_CONFIGURATION = 2;
    public static final int WINDOW_ID_DEBUG = 3;
    public static final int WINDOW_ID_IECLOG = 4;
    public static final int WINDOW_ID_VIA1 = 5;
    public static final int WINDOW_ID_VIA2 = 6;
    public static final int WINDOW_ID_SETTINGS = 7;

    public WindowData(String appName, ConsoleFrame console) {
        this.console = console;
        this.window_manager = new WindowManager(appName);
        this.window_manager.addObserver(this);
        this.menu_selected_icon = new ImageIcon("images/menu_selected_icon.png");
        this.menu_unselected_icon = new ImageIcon("images/menu_unselected_icon.png");
        this.window_menu_map = new HashMap();
    }

    void addWindowMenu(JMenu menu, String caption, int window_id) {
        try {
            JMenuItem menu_item = new JMenuItem(caption, this.menu_unselected_icon);
            menu_item.addActionListener(this.createListenerForId(window_id));
            this.window_menu_map.put(window_id, menu_item);
            menu.add(menu_item);
        }
        catch (Exception ex) {
            logger.info("Window \"" + caption + "\" not available.", (Throwable)ex);
        }
    }

    private ActionListener createListenerForId(int window_id) {
        ActionListener windowListener = null;
        if (window_id == 1) {
            windowListener = new WindowMemory(this.window_manager, window_id, this.console.getAssembler(), this.console.getMemory());
        } else if (window_id == 2) {
            windowListener = new WindowConfiguration(this.window_manager, window_id, this.console.getBus());
        } else if (window_id == 3) {
            windowListener = new WindowDebug(this.window_manager, window_id, this.console.getAssembler(), (Cpu6502)this.console.getCpu(), this.console.getMemory());
        } else if (window_id == 4) {
            windowListener = new WindowIEC(this.window_manager, window_id, this.console.getIecSim(), this.console.getVia1(), (Cpu6502)this.console.getCpu(), this.console.getPortStateHistory1(), this.console.getPortStateHistory2());
        } else if (window_id == 5) {
            windowListener = new WindowVia(this.window_manager, window_id, "VIA 1", this.console.getVia1(), (Cpu6502)this.console.getCpu(), this.console.getPortStateHistory1());
        } else if (window_id == 6) {
            windowListener = new WindowVia(this.window_manager, window_id, "VIA 2", this.console.getVia2(), (Cpu6502)this.console.getCpu(), this.console.getPortStateHistory2());
        } else if (window_id == 7) {
            windowListener = new WindowSettings(this.window_manager, window_id, this.console.getClock());
        }
        return windowListener;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updateWindowStates();
    }

    void updateWindowStates() {
        for (Map.Entry<Integer, JMenuItem> entry : this.window_menu_map.entrySet()) {
            if (this.window_manager.isWindowActive(entry.getKey())) {
                entry.getValue().setIcon(this.menu_selected_icon);
                continue;
            }
            entry.getValue().setIcon(this.menu_unselected_icon);
        }
    }

    public void saveWindowStates() {
        Preferences cfg = Preferences.userNodeForPackage(this.getClass());
        for (Map.Entry<Integer, JMenuItem> entry : this.window_menu_map.entrySet()) {
            cfg.putBoolean(String.valueOf(this.window_manager.getAppName()) + "$" + entry.getKey(), this.window_manager.isWindowActive(entry.getKey()));
        }
    }

    public void restoreWindowStates() {
        Preferences cfg = Preferences.userNodeForPackage(this.getClass());
        for (Map.Entry<Integer, JMenuItem> entry : this.window_menu_map.entrySet()) {
            boolean makeActive = cfg.getBoolean(String.valueOf(this.window_manager.getAppName()) + "$" + entry.getKey(), false);
            if (makeActive == this.window_manager.isWindowActive(entry.getKey())) continue;
            entry.getValue().doClick();
        }
    }
}

