/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.assembler.AddressDictionary;
import emulator.assembler.Assembler;
import emulator.assembler.DataDescription;
import emulator.assembler.Instruction;
import emulator.assembler.SymbolTable;
import emulator.assembler.SymbolTableEntry;
import emulator.hardware.HwNumber;
import emulator.hardware.debug.CpuProfiler;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.debugger.CodeInfo;
import emulator.shell.GUI.debugger.CodePanelAnalyzer;
import emulator.shell.GUI.debugger.CodePanelPosition;
import emulator.shell.GUI.debugger.DebugPanel;
import emulator.shell.GUI.debugger.ScrollView;
import emulator.shell.GUI.symbols.EditSymbolDialog;
import emulator.util.AddressRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CodePanel
extends ScrollView
implements AddressDictionary {
    private static final int LABEL_MAX = 16;
    private static final int X_LABEL = 15;
    private static final int X_OPERAND = 38;
    private static final int STATE_DISPLAY_CODE = 0;
    private static final int STATE_INIT_CPU_RUNNING = 1;
    private static final int STATE_INIT_ANALYZE_CODE = 2;
    private int panel_state;
    private CodeInfo code_info = null;
    private Cpu6502 cpu;
    private CodePanelPosition position = new CodePanelPosition(10, 0, 10);
    private boolean is_running;
    private CodePanelAnalyzer analyzer = new CodePanelAnalyzer();
    private boolean is_single_step;
    private JPopupMenu popup;
    private DebugPanel debug_panel;
    private CpuProfiler profiler = new CpuProfiler(65536);
    private boolean profiler_active = false;
    private SymbolTableObserver symbolTableObserver = new SymbolTableObserver();
    private ProfilerObserver profilerObserver = new ProfilerObserver();

    public CodePanel(Assembler assembler, Cpu6502 cpu, byte[] memory, DebugPanel debug_panel) {
        this.code_info = new CodeInfo(memory, assembler, 65536);
        this.cpu = cpu;
        this.debug_panel = debug_panel;
        this.profiler.reset();
        this.panel_state = 1;
        this.is_running = true;
        this.is_single_step = false;
        this.setCurrentPosition(0);
        this.setCurrentRange(this.code_info.size());
        this.initPanel();
        this.getProfiler().addObserver(this.profilerObserver);
        this.getSymbolTable().addObserver(this.symbolTableObserver);
        this.updateRunState(cpu.isRunning());
        this.addKeyListener(new ScrollView.KeyboardListener(this));
    }

    public void shutdown() {
        this.getProfiler().deleteObserver(this.profilerObserver);
        this.getSymbolTable().deleteObserver(this.symbolTableObserver);
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.initScrollBar();
        this.add((Component)new LineMarker(), "West");
        this.scroll_pane = new CodePane();
        this.add((Component)this.scroll_pane, "Center");
        this.scroll_pane.addKeyListener(new ScrollView.KeyboardListener(this));
        this.addMouseWheelListener(new ScrollView.MouseScrollListener(this));
        this.popup = new JPopupMenu();
        this.addPopupItem("Run to cursor", "runto");
        this.popup.addSeparator();
        this.addPopupItem("Scroll to PC", "topc");
        this.popup.addSeparator();
        this.addPopupItem("Set breakpoint", "setbreak");
        this.addPopupItem("Clear breakpoint", "delbreak");
        this.popup.addSeparator();
        this.addPopupItem("Unassemble", "analyze");
        this.popup.addSeparator();
        this.addPopupItem("Edit symbol...", "symbol");
    }

    private JMenuItem addPopupItem(String caption, String command) {
        JMenuItem item = new JMenuItem(caption);
        item.setActionCommand(command);
        item.addActionListener(new PopupMenuListener());
        this.popup.add(item);
        return item;
    }

    public void updateRunState(boolean run_state) {
        boolean update_panel = false;
        if (run_state) {
            this.is_running = true;
        } else if (!this.analyzer.isRunning()) {
            if (this.panel_state == 1) {
                this.panel_state = 2;
                update_panel = true;
            }
            this.is_running = false;
            int address = this.cpu.getPC();
            if (this.is_single_step) {
                this.is_single_step = false;
                this.code_info.analyzeOneInstruction(address);
                this.setCurrentRange(this.code_info.size());
                this.ensureVisible(this.code_info.getIndexForAddress(address), false);
                this.panel_state = 0;
                update_panel = true;
            } else {
                this.analyzer.startAnalysis(address, this.code_info, new CodeAnalyzerObserver(address));
            }
        }
        if (update_panel) {
            this.showScrollBar(this.isPanelActive());
            this.repaint();
        }
    }

    @Override
    boolean isPanelActive() {
        return this.panel_state == 0;
    }

    public void updateAnalyzerState(boolean analyzer_running, int pc) {
        if (!analyzer_running && this.analyzer.isRunning()) {
            this.analyzer.ackStop();
            this.panel_state = 0;
            if (this.position.getCurrentPosition() > 0) {
                int address = this.code_info.getAddressForIndex(this.position.getCurrentPosition());
                this.position.setCurrentPosition(this.analyzer.getDescriptionTable().getIndexForAddress(address));
            }
            this.code_info.setDescriptionTable(this.analyzer.getDescriptionTable());
            this.setCurrentRange(this.code_info.size());
            try {
                this.ensureVisible(this.code_info.getIndexForAddress(pc), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.showScrollBar(this.isPanelActive());
            this.repaint();
        }
    }

    public void go() {
        this.cpu.go();
        this.repaint();
    }

    public void halt() {
        this.cpu.halt();
    }

    public void stepInto() {
        this.is_single_step = true;
        this.cpu.step();
    }

    public void stepOver() {
        this.is_single_step = true;
        this.cpu.stepOver();
    }

    public void stepOut() {
        this.cpu.enableBreakOnReturn(true);
        this.cpu.go();
    }

    public boolean search(String search_text) {
        int address = -1;
        try {
            address = AddressRange.addressFromString(search_text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (address < 0) {
                address = this.code_info.findLabel(search_text);
            }
            this.showCode(address, true);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    int getCurrentPosition() {
        return this.position.getCurrentPosition();
    }

    @Override
    void setCurrentRange(int current_range) {
        this.position.setCurrentRange(current_range);
    }

    @Override
    int getCurrentRange() {
        return this.position.getCurrentRange();
    }

    @Override
    int getVisibleLines() {
        return this.position.getVisibleLines();
    }

    @Override
    void setCurrentPosition(int desired_position) {
        this.position.setCurrentPosition(desired_position);
    }

    @Override
    void setVisibleLines(int i) {
        this.position.setVisibleLines(i);
    }

    public void showCode(int address, boolean update) {
        this.analyzeAddress(address);
        if (update) {
            this.position.setSelectedAddress(address);
        }
        this.ensureVisible(this.code_info.getIndexForAddress(address), update);
    }

    public void loadSymbols(String selected_file) {
        try {
            this.code_info.getAssembler().loadSymbols(new FileInputStream(selected_file), selected_file);
            int address = this.code_info.findLabel("@Start");
            if (address >= 0) {
                this.position.setSelectedAddress(address);
                this.ensureVisible(this.code_info.getIndexForAddress(address), false);
                if (!this.analyzer.isRunning()) {
                    this.analyzer.startAnalysis(address, this.code_info, new CodeAnalyzerObserver(address));
                }
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, e, "Failed to load symbols", 0);
        }
        this.repaint();
    }

    @Override
    public String getLabel(int source) {
        return this.code_info.getLabel(source);
    }

    private void analyzeAddress(int address) {
        if (!this.analyzer.isRunning()) {
            this.analyzer.startAnalysis(address, this.code_info, new CodeAnalyzerObserver(address));
        }
    }

    private void editSymbol(int address) {
        SymbolTableEntry entry = this.getSymbolTable().getSymbolEntry(address);
        if (entry == null) {
            entry = new SymbolTableEntry();
            entry.setAddress(address);
        }
        EditSymbolDialog dialog = new EditSymbolDialog(null, entry);
        dialog.setVisible(true);
        if (dialog.getResult()) {
            this.getSymbolTable().addSymbol(address, dialog.getLabel(), dialog.getRemark(), dialog.getType());
        }
    }

    public void enableProfiler(boolean enable) {
        this.profiler_active = enable;
        this.profiler.enable(this.cpu, enable);
        if (this.isPanelActive()) {
            this.repaint();
        }
    }

    public CpuProfiler getProfiler() {
        return this.profiler;
    }

    public SymbolTable getSymbolTable() {
        return this.code_info.getAssembler().getSymbols();
    }

    class CodeAnalyzerObserver
    implements Observer,
    Runnable {
        private boolean new_state;
        private int pc;

        public CodeAnalyzerObserver(int pc) {
            this.pc = pc;
        }

        @Override
        public void update(Observable arg0, Object analyzer_running) {
            this.new_state = (Boolean)analyzer_running;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            CodePanel.this.updateAnalyzerState(this.new_state, this.pc);
        }
    }

    class CodePane
    extends ScrollView.ScrollPane {
        private int profile_x;
        private int profile_dx;
        private final int prof_bar_ch_width = 3;

        public CodePane() {
            super(CodePanel.this);
            this.prof_bar_ch_width = 3;
            this.addMouseListener(new MouseEventHandler());
            this.setToolTipText("Code window");
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(UIManager.getColor("ScrollPane.background"));
            g.fillRect(0, 0, d.width, d.height);
            g.setFont(CodePanel.this.getTextFont());
            if (CodePanel.this.isPanelActive()) {
                int i = 0;
                while (i < CodePanel.this.position.getVisibleLines()) {
                    int index = CodePanel.this.position.getCurrentPosition() + i;
                    DataDescription data = CodePanel.this.code_info.getDescriptionForIndex(index);
                    if (data == null) break;
                    int address = data.getAddress();
                    g.setColor(UIManager.getColor("ScrollPane.background"));
                    g.fillRect(CodePanel.this.getBorderSize(), CodePanel.this.getBorderSize() + i * CodePanel.this.getLineMetrics().getLineHeight() + 1, CodePanel.this.getLineMetrics().getLineWidth(), CodePanel.this.getLineMetrics().getLineHeight() - 1);
                    int x = 0;
                    int rc_left = CodePanel.this.getBorderSize();
                    int rc_width = CodePanel.this.getLineMetrics().getLineWidth();
                    if (CodePanel.this.profiler_active) {
                        this.profile_x = this.getTextWidth(x);
                        this.profile_dx = this.getTextWidth(3);
                        int dx_act = (CodePanel.this.profiler.getStatisticsForAddress(address).getExecutionCounter() + 9) / 10;
                        if (dx_act > this.profile_dx) {
                            dx_act = this.profile_dx;
                        }
                        g.setColor(CodePanel.this.is_running ? Color.darkGray : Color.blue);
                        g.fillRect(this.profile_x, CodePanel.this.getBorderSize() + i * CodePanel.this.getLineMetrics().getLineHeight() + 1, dx_act, CodePanel.this.getLineMetrics().getLineHeight() - 1);
                        x += 4;
                        rc_left += this.profile_dx + CodePanel.this.getBorderSize();
                        rc_width -= this.profile_dx + CodePanel.this.getBorderSize();
                    }
                    if (address == CodePanel.this.cpu.getPC()) {
                        g.setColor(CodePanel.this.is_running ? Color.gray : Color.black);
                        g.drawRect(rc_left - 1, CodePanel.this.getBorderSize() + i * CodePanel.this.getLineMetrics().getLineHeight(), rc_width, CodePanel.this.getLineMetrics().getLineHeight());
                        g.setColor(Color.blue);
                    } else {
                        g.setColor(Color.black);
                    }
                    if (CodePanel.this.position.isSelectedAddress(address)) {
                        g.setColor(Color.blue);
                        g.fillRect(rc_left, CodePanel.this.getBorderSize() + i * CodePanel.this.getLineMetrics().getLineHeight() + 1, rc_width - 1, CodePanel.this.getLineMetrics().getLineHeight() - 1);
                        g.setColor(Color.white);
                    }
                    String s = "0000" + Integer.toHexString(address).toUpperCase();
                    s = s.substring(s.length() - 4);
                    this.printString(g, s, x, i);
                    x += 5;
                    try {
                        Instruction instruction = data.getInstruction(CodePanel.this.code_info.getAssembler(), CodePanel.this.code_info.getMemory());
                        this.printString(g, instruction.getBytesShort(), x, i);
                        assert ((x += 10) == 15 + this.getProfileColSize());
                        String label = CodePanel.this.code_info.getJumpLabel(address);
                        if (label != null) {
                            if (label.length() > 16) {
                                label = label.substring(0, 16);
                            }
                            label = String.valueOf(label) + ":";
                            this.printString(g, label, x, i);
                        }
                        this.printString(g, instruction.getOpcode(), x += 18, i);
                        assert ((x += 5) == 38 + this.getProfileColSize());
                        this.printString(g, instruction.getOperand(), x, i);
                        x += 24;
                        String remark = CodePanel.this.code_info.getRemark(address);
                        if (remark != null) {
                            this.printString(g, "; " + remark, x, i);
                        }
                    }
                    catch (Exception e) {
                        g.setColor(Color.red);
                        this.printString(g, "Internal error " + e.getClass().getName(), x, i);
                    }
                    ++i;
                }
            } else {
                g.setColor(Color.darkGray);
                if (CodePanel.this.panel_state == 1) {
                    this.printString(g, "CPU running...", 0, 0);
                } else if (CodePanel.this.panel_state == 2) {
                    this.printString(g, "Analyzing...", 0, 0);
                } else {
                    this.printString(g, "Internal Error", 0, 0);
                }
            }
        }

        private int getProfileColSize() {
            return CodePanel.this.profiler_active ? 4 : 0;
        }

        public String getToolTipForLine(int line, int x) {
            DataDescription data;
            if (CodePanel.this.profiler_active && x >= this.profile_x && x < this.profile_x + this.profile_dx) {
                int address = CodePanel.this.code_info.getAddressForIndex(line);
                return CodePanel.this.profiler.getStatisticsForAddress(address).getToolTip();
            }
            int i = line - CodePanel.this.position.getCurrentPosition();
            if (i >= 0 && (data = CodePanel.this.code_info.getDescriptionForIndex(line)) != null) {
                Instruction instruction = data.getInstruction(CodePanel.this.code_info.getAssembler(), CodePanel.this.code_info.getMemory());
                Rectangle rc_operand = new Rectangle();
                this.getBoundingRect(instruction.getOperand(), 38 + this.getProfileColSize(), i, rc_operand);
                if (x >= rc_operand.x && x < rc_operand.x + rc_operand.width) {
                    return instruction.getOperandDetails(CodePanel.this.cpu, CodePanel.this.code_info.getMemory());
                }
                String label = CodePanel.this.code_info.getJumpLabel(data.getAddress());
                if (label != null && label.length() > 16) {
                    String short_label = label.substring(0, 16);
                    Rectangle rc_label = new Rectangle();
                    this.getBoundingRect(short_label, 15 + this.getProfileColSize(), i, rc_label);
                    if (x >= rc_label.x && x < rc_label.x + rc_label.width) {
                        return label;
                    }
                }
            }
            return null;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point point = event.getPoint();
            int line = this.hitTest(point);
            if (line >= 0) {
                return this.getToolTipForLine(line, point.x);
            }
            return super.getToolTipText(event);
        }

        class MouseEventHandler
        extends MouseAdapter {
            MouseEventHandler() {
            }

            private void handleSelect(Point point) {
                CodePane.this.requestFocusInWindow();
                int line = CodePane.this.hitTest(point);
                int address = CodePanel.this.code_info.getAddressForIndex(line);
                CodePanel.this.position.setSelectedAddress(address);
                CodePane.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!this.checkPopup(event)) {
                    this.handleSelect(event.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            private boolean checkPopup(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.handleSelect(event.getPoint());
                    CodePanel.this.popup.show(CodePane.this, event.getX(), event.getY());
                    return true;
                }
                return false;
            }
        }
    }

    public class LineMarker
    extends JPanel {
        private int width = 24;

        public LineMarker() {
            this.addMouseListener(new MouseEventHandler());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            d.setSize(this.width, this.width);
            return d;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rec = this.getBounds();
            g.setColor(UIManager.getColor("ScrollPane.background"));
            g.fillRect(0, 0, rec.width, rec.height);
            if (CodePanel.this.isPanelActive()) {
                int mid_x = rec.width / 2;
                int mid_y = CodePanel.this.getBorderSize() + CodePanel.this.getLineMetrics().getLineHeight() / 2;
                int width = rec.width - 2 * CodePanel.this.getBorderSize();
                int height = CodePanel.this.getLineMetrics().getLineHeight() - 2 * CodePanel.this.getBorderSize();
                int i = 0;
                while (i < CodePanel.this.position.getVisibleLines()) {
                    int index = CodePanel.this.position.getCurrentPosition() + i;
                    DataDescription data = CodePanel.this.code_info.getDescriptionForIndex(index);
                    if (data == null) break;
                    int address = data.getAddress();
                    if (CodePanel.this.cpu.isBreakpoint(address)) {
                        g.setColor(Color.red);
                        int diameter = Math.min(width, height);
                        g.fillOval(mid_x - diameter / 2, mid_y - diameter / 2, diameter, diameter);
                    }
                    if (address == CodePanel.this.cpu.getPC()) {
                        Polygon p = new Polygon();
                        p.addPoint(mid_x / 2, mid_y - height / 2);
                        p.addPoint(mid_x / 2, mid_y + height / 2);
                        p.addPoint(mid_x + width / 2, mid_y);
                        g.setColor(CodePanel.this.cpu.isRunning() ? Color.darkGray : Color.black);
                        g.fillPolygon(p);
                    }
                    mid_y += CodePanel.this.getLineMetrics().getLineHeight();
                    ++i;
                }
            }
        }

        class MouseEventHandler
        extends MouseAdapter {
            MouseEventHandler() {
            }

            private void handleDoubleClick(Point point) {
                int line = CodePanel.this.hitTest(point);
                int address = CodePanel.this.code_info.getAddressForIndex(line);
                CodePanel.this.cpu.breakAt(new HwNumber(address), !CodePanel.this.cpu.isBreakpoint(address));
                LineMarker.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    this.handleDoubleClick(event.getPoint());
                }
            }
        }
    }

    public class PopupMenuListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            int address = CodePanel.this.position.getSelectedAddress();
            HwNumber hw_address = new HwNumber(address);
            if (event.getActionCommand().equals("runto")) {
                CodePanel.this.debug_panel.onPreRun();
                CodePanel.this.cpu.stopOnceAt(hw_address);
                CodePanel.this.cpu.go();
            } else if (event.getActionCommand().equals("setbreak")) {
                CodePanel.this.cpu.breakAt(hw_address, true);
            } else if (event.getActionCommand().equals("delbreak")) {
                CodePanel.this.cpu.breakAt(hw_address, false);
            } else if (event.getActionCommand().equals("analyze")) {
                CodePanel.this.analyzeAddress(address);
            } else if (event.getActionCommand().equals("topc")) {
                CodePanel.this.showCode(CodePanel.this.cpu.getPC(), false);
            } else if (event.getActionCommand().equals("symbol")) {
                CodePanel.this.editSymbol(address);
            }
            CodePanel.this.repaint();
        }
    }

    public class ProfilerObserver
    implements Observer,
    Runnable {
        @Override
        public void update(Observable o, Object arg) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            CodePanel.this.repaint();
        }
    }

    public class SymbolTableObserver
    implements Observer,
    Runnable {
        @Override
        public void update(Observable o, Object arg) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            CodePanel.this.repaint();
        }
    }
}

