/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.GUI.PersistentFrame;
import emulator.assembler.Assembler;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.ToolBarWindow;
import emulator.shell.GUI.debugger.CodePanel;
import emulator.shell.GUI.debugger.CpuRegisterPanel;
import emulator.shell.GUI.debugger.StackPanel;
import emulator.shell.GUI.profiling.ProfilingStatisticsPresenter;
import emulator.shell.GUI.symbols.SymbolTablePresenter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DebugPanel
extends ToolBarWindow {
    private PersistentFrame parent;
    private CodePanel code_panel;
    private StackPanel stack_panel;
    private JButton button_go;
    private JButton button_halt;
    private JButton button_step_into;
    private JButton button_step_over;
    private JButton button_step_out;
    private JTextField textfield_search;
    private JButton button_search;
    private JButton button_symbols;
    private JCheckBox checkbox_profile;
    private JButton button_statistics;
    private CpuRegisterPanel cpu_registers;
    private CpuStateObserver cpu_state_observer;
    private Cpu6502 cpu;
    private ProfilingStatisticsPresenter profilingStatisticsPresenter = null;
    private SymbolTablePresenter symbolTablePresenter = null;

    public DebugPanel(PersistentFrame parent, Assembler assembler, Cpu6502 cpu, byte[] memory) {
        this.parent = parent;
        this.cpu = cpu;
        parent.addWindowListener(new WindowListener());
        this.cpu_state_observer = new CpuStateObserver();
        cpu.addRunningStateObserver(this.cpu_state_observer);
        this.setLayout(new BorderLayout());
        this.toolbar = this.createToolbar();
        this.cpu_registers = new CpuRegisterPanel(cpu);
        this.code_panel = new CodePanel(assembler, cpu, memory, this);
        this.code_panel.setFocusable(true);
        this.stack_panel = new StackPanel(cpu.getStack(), this.code_panel);
        this.profilingStatisticsPresenter = new ProfilingStatisticsPresenter(parent.getAppName(), this.code_panel);
        this.symbolTablePresenter = new SymbolTablePresenter(parent.getAppName(), this.code_panel);
        JSplitPane split_pane = new JSplitPane(0, this.code_panel, this.stack_panel);
        split_pane.setDividerLocation(this.loadDividerLocation());
        split_pane.addPropertyChangeListener("dividerLocation", new DividerListener());
        this.add((Component)this.toolbar, "First");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.cpu_registers, "First");
        panel.add((Component)split_pane, "Center");
        this.add((Component)panel, "Center");
        this.updateRunState(cpu.isRunning());
    }

    private int loadDividerLocation() {
        return this.parent.loadInt("DebugPanel.divider", 62);
    }

    public void saveDividerLocation(int location) {
        this.parent.saveInt("DebugPanel.divider", location);
    }

    public void shutdown() {
        this.cpu.deleteRunningStateObserver(this.cpu_state_observer);
        this.code_panel.shutdown();
    }

    private JToolBar createToolbar() {
        this.button_go = DebugPanel.makeNavigationButton("images/run_icon.png", "start running", "go", new Go());
        this.button_halt = DebugPanel.makeNavigationButton("images/stop_icon.png", "stop running", "halt", new Halt());
        this.button_step_into = DebugPanel.makeNavigationButton("images/step_into.png", "step into", "into", new StepInto());
        this.button_step_over = DebugPanel.makeNavigationButton("images/step_over.png", "step over", "over", new StepOver());
        this.button_step_out = DebugPanel.makeNavigationButton("images/step_out.png", "step out", "out", new StepOut());
        this.textfield_search = new JTextField();
        this.textfield_search.addActionListener(new Search());
        this.textfield_search.getDocument().addDocumentListener(new ResetSearch());
        this.textfield_search.setToolTipText("<html><b>Enter search text here.</b><br><br>Search for a <i>code location</i> by <i>address</i> or <i>label</i> (e.g. '$3FC0' or 'init')<br></html>");
        this.button_search = DebugPanel.makeNavigationButton("images/search_icon.png", "search", "search", new Search());
        this.button_symbols = DebugPanel.makeNavigationButton("images/load_symbols.png", "load symbols", "symbols", new LoadSymbols());
        this.button_statistics = DebugPanel.makeNavigationButton("images/statistics.png", "show statistics", "statistics", new ShowStats());
        this.checkbox_profile = new JCheckBox("profile");
        this.checkbox_profile.setSelected(false);
        this.checkbox_profile.addItemListener(new CheckProfile());
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.button_go);
        toolbar.add(this.button_halt);
        toolbar.add(this.button_step_into);
        toolbar.add(this.button_step_over);
        toolbar.add(this.button_step_out);
        toolbar.addSeparator();
        toolbar.add(this.textfield_search);
        toolbar.add(this.button_search);
        toolbar.addSeparator();
        toolbar.add(this.button_symbols);
        toolbar.addSeparator();
        toolbar.add(this.button_statistics);
        toolbar.add(this.checkbox_profile);
        return toolbar;
    }

    private void updateRunState(boolean run_state) {
        if (run_state) {
            this.button_go.setEnabled(false);
            this.button_halt.setEnabled(true);
            this.button_step_into.setEnabled(false);
            this.button_step_over.setEnabled(false);
            this.button_step_out.setEnabled(false);
            this.checkbox_profile.setEnabled(false);
            this.button_statistics.setEnabled(false);
        } else {
            this.button_go.setEnabled(true);
            this.button_halt.setEnabled(false);
            this.button_step_into.setEnabled(true);
            this.button_step_over.setEnabled(true);
            this.button_step_out.setEnabled(true);
            this.checkbox_profile.setEnabled(true);
            this.button_statistics.setEnabled(true);
        }
        this.cpu_registers.updateValues(run_state);
        this.code_panel.updateRunState(run_state);
        this.stack_panel.updateRunState(run_state);
    }

    public void onPreRun() {
        this.cpu_registers.transferValuesToCPU();
    }

    private class CheckProfile
    implements ItemListener {
        private CheckProfile() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                DebugPanel.this.code_panel.enableProfiler(true);
            } else if (event.getStateChange() == 2) {
                DebugPanel.this.code_panel.enableProfiler(false);
            }
        }
    }

    class CpuStateObserver
    implements Observer {
        CpuStateObserver() {
        }

        @Override
        public void update(Observable state, Object run_state) {
            SwingUtilities.invokeLater(new CpuStateEvent((Boolean)run_state));
        }

        class CpuStateEvent
        implements Runnable {
            private boolean run_state;

            public CpuStateEvent(boolean run_state) {
                this.run_state = run_state;
            }

            @Override
            public void run() {
                DebugPanel.this.updateRunState(this.run_state);
            }
        }
    }

    class DividerListener
    implements PropertyChangeListener {
        DividerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Number value = (Number)e.getNewValue();
            DebugPanel.this.saveDividerLocation(value.intValue());
        }
    }

    public class Go
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.onPreRun();
            DebugPanel.this.code_panel.go();
        }
    }

    public class Halt
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.code_panel.halt();
        }
    }

    public class LoadSymbols
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.symbolTablePresenter.toggleView();
        }
    }

    public class ResetSearch
    implements DocumentListener {
        private void resetVisualState() {
            Color bk_color = UIManager.getColor("TextField.background");
            DebugPanel.this.textfield_search.setBackground(bk_color);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.resetVisualState();
        }
    }

    public class Search
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            String search_text = DebugPanel.this.textfield_search.getText();
            if (!search_text.isEmpty() && !DebugPanel.this.code_panel.search(search_text)) {
                DebugPanel.this.textfield_search.setBackground(Color.ORANGE);
            }
        }
    }

    public class ShowStats
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            DebugPanel.this.profilingStatisticsPresenter.toggleView();
        }
    }

    public class StepInto
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.onPreRun();
            DebugPanel.this.code_panel.stepInto();
        }
    }

    public class StepOut
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.onPreRun();
            DebugPanel.this.code_panel.stepOut();
        }
    }

    public class StepOver
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            DebugPanel.this.onPreRun();
            DebugPanel.this.code_panel.stepOver();
        }
    }

    public class WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            DebugPanel.this.profilingStatisticsPresenter.closeView();
            DebugPanel.this.symbolTablePresenter.closeView();
            DebugPanel.this.shutdown();
        }
    }
}

