/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.graph.BitGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class GraphWindow {
    protected BitGraph panelGraph;
    protected long currentGraphRange = 1000L;
    protected long currentTick = 0L;
    protected Cpu6502 cpu;
    protected CpuObserver cpuObserver = new CpuObserver();

    protected JPanel createGraphFrame() {
        this.panelGraph = this.createGraph();
        JToolBar toolBar = this.createToolBar();
        JPanel graphFrame = new JPanel();
        graphFrame.setLayout(new BorderLayout());
        graphFrame.add((Component)toolBar, "First");
        graphFrame.add((Component)this.panelGraph, "Center");
        return graphFrame;
    }

    private JToolBar createToolBar() {
        JButton buttonBack = new JButton(new ImageIcon("images/back.png"));
        buttonBack.setToolTipText("Scroll the graph back in time");
        buttonBack.addActionListener(new Back());
        JButton buttonForward = new JButton(new ImageIcon("images/forward.png"));
        buttonForward.setToolTipText("Scroll the graph forward in time");
        buttonForward.addActionListener(new Forward());
        JButton buttonBackPage = new JButton(new ImageIcon("images/Rewind24.gif"));
        buttonBackPage.setToolTipText("Scroll the graph back in time by one page");
        buttonBackPage.addActionListener(new PageBack());
        JButton buttonForwardPage = new JButton(new ImageIcon("images/FastForward24.gif"));
        buttonForwardPage.setToolTipText("Scroll the graph forward in time by one page");
        buttonForwardPage.addActionListener(new PageForward());
        JComboBox<String> boxRange = new JComboBox<String>(new String[]{"10", "100", "1000", "10000", "100000", "1000000", "10000000"});
        boxRange.setSelectedIndex(2);
        boxRange.addActionListener(new RangeSelect());
        JToolBar toolBar = new JToolBar();
        toolBar.add(buttonBackPage);
        toolBar.add(buttonBack);
        toolBar.add(boxRange);
        toolBar.add(new JLabel(" Ticks"));
        toolBar.add(buttonForward);
        toolBar.add(buttonForwardPage);
        return toolBar;
    }

    protected abstract BitGraph createGraph();

    protected abstract void onCpuStoppped();

    protected abstract long getMaxTicks();

    protected void updateGraphRange() {
        if (this.panelGraph != null) {
            if (this.currentTick < this.currentGraphRange) {
                this.panelGraph.setRange(0L, this.currentTick);
            } else {
                this.panelGraph.setRange(this.currentTick - this.currentGraphRange + 1L, this.currentTick);
            }
        }
    }

    public void moveGraph(long tickOffset) {
        long maxTick;
        long newEnd = this.currentTick + tickOffset;
        if (newEnd < this.currentGraphRange) {
            newEnd = this.currentGraphRange;
        }
        if (newEnd > (maxTick = this.getMaxTicks())) {
            newEnd = maxTick;
        }
        this.currentTick = newEnd;
        this.updateGraphRange();
        this.panelGraph.repaint();
    }

    public class Back
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphWindow.this.moveGraph(-GraphWindow.this.panelGraph.getRange() / (long)GraphWindow.this.panelGraph.getScalesSteps());
        }
    }

    public class CpuObserver
    implements Observer,
    Runnable {
        @Override
        public void update(Observable o, Object arg) {
            if (!GraphWindow.this.cpu.isRunning()) {
                GraphWindow.this.currentTick = GraphWindow.this.getMaxTicks();
                GraphWindow.this.updateGraphRange();
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            GraphWindow.this.onCpuStoppped();
            if (GraphWindow.this.panelGraph != null) {
                GraphWindow.this.panelGraph.repaint();
            }
        }
    }

    public class Forward
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphWindow.this.moveGraph(GraphWindow.this.panelGraph.getRange() / (long)GraphWindow.this.panelGraph.getScalesSteps());
        }
    }

    public class PageBack
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphWindow.this.moveGraph(-GraphWindow.this.currentGraphRange);
        }
    }

    public class PageForward
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphWindow.this.moveGraph(GraphWindow.this.currentGraphRange);
        }
    }

    public class RangeSelect
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            String rangeText = (String)cb.getSelectedItem();
            long newRange = Long.parseLong(rangeText);
            long offset = newRange - GraphWindow.this.currentGraphRange;
            GraphWindow.this.currentGraphRange = newRange;
            GraphWindow.this.moveGraph(offset);
        }
    }
}

