/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.util.AddressRange;
import emulator.util.file.FileHelper;
import emulator.util.file.FileInfo;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class MemoryFileDialog
extends JDialog
implements ActionListener {
    private int file_format;
    private boolean result_valid;
    private boolean is_save_dialog;
    private JTextField file_name_field;
    private JTextField start_address_field;
    private JTextField block_size_field;
    private HashMap<Integer, JRadioButton> select_file_format = new HashMap();
    private JCheckBox relink_basic_button;
    private boolean relink_basic;

    MemoryFileDialog(JFrame parent, String title, boolean is_save_dialog) {
        super(parent, title, true);
        this.is_save_dialog = is_save_dialog;
        this.buildContents();
        this.pack();
        this.setLocationRelativeTo(null);
        this.result_valid = false;
        this.relink_basic = false;
        this.file_format = 2;
        this.setFormatButton();
    }

    public boolean isResultValid() {
        return this.result_valid;
    }

    public String getFileName() {
        return this.file_name_field.getText();
    }

    public int getStartAddress() {
        return this.fetchNumberFromField(this.start_address_field);
    }

    public int getBlockSize() {
        return this.fetchNumberFromField(this.block_size_field);
    }

    public int getFileFormat() {
        return this.file_format;
    }

    public boolean getRelinkBasic() {
        return this.relink_basic;
    }

    public void setStartAddress(int start_address) {
        this.setNumberToField(this.start_address_field, start_address);
    }

    public void setBlockSize(int block_size) {
        this.setNumberToField(this.block_size_field, block_size);
    }

    private void buildContents() {
        JLabel label1 = new JLabel("Memory File");
        this.file_name_field = new JTextField();
        JLabel label2 = new JLabel("Start Address");
        this.start_address_field = new JTextField();
        JLabel label3 = new JLabel("Block Size");
        this.block_size_field = new JTextField();
        JButton file_button = this.createCommandButton("Browse...", "browse");
        JButton ok_button = this.createCommandButton("OK", "ok");
        JButton cancel_button = this.createCommandButton("Cancel", "cancel");
        JSeparator format_top = new JSeparator(0);
        JSeparator format_bot = new JSeparator(0);
        JRadioButton select_format_raw = this.createFormatSelectButton("Raw data", "select_raw", 1, true);
        JRadioButton select_format_prg = this.createFormatSelectButton("Address as header (.prg)", "select_prg", 2, true);
        JRadioButton select_format_p00 = this.createFormatSelectButton("PC64 format (.P00)", "select_p00", 5, !this.is_save_dialog);
        JRadioButton select_format_s20 = this.createFormatSelectButton("Phau Zeh saved session (.s20)", "select_s20", 4, false);
        JRadioButton select_format_pcv = this.createFormatSelectButton("PCVIC system snapshot (.pcv)", "select_pcvic", 3, !this.is_save_dialog);
        JRadioButton select_format_crt = this.createFormatSelectButton("CCS64 cartridge image (.crt)", "select_crt", 6, false);
        JRadioButton select_format_sid = this.createFormatSelectButton("SID file (.sid)", "select_sid", 7, !this.is_save_dialog);
        this.setFormatButton();
        ButtonGroup select_format_group = new ButtonGroup();
        select_format_group.add(select_format_raw);
        select_format_group.add(select_format_prg);
        select_format_group.add(select_format_p00);
        select_format_group.add(select_format_s20);
        select_format_group.add(select_format_pcv);
        select_format_group.add(select_format_crt);
        select_format_group.add(select_format_sid);
        this.relink_basic_button = new JCheckBox("BASIC");
        this.relink_basic_button.setSelected(this.relink_basic);
        this.relink_basic_button.setEnabled(!this.is_save_dialog);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label1).addComponent(label2).addComponent(label3)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.file_name_field).addComponent(this.start_address_field).addComponent(this.block_size_field)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(file_button).addComponent(this.relink_basic_button))).addComponent(format_top).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(select_format_prg).addComponent(select_format_s20).addComponent(select_format_pcv).addComponent(select_format_crt)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(select_format_raw).addComponent(select_format_p00).addComponent(select_format_sid))).addComponent(format_bot).addGroup(layout.createSequentialGroup().addComponent(ok_button).addComponent(cancel_button)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label1).addComponent(this.file_name_field).addComponent(file_button)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label2).addComponent(this.start_address_field).addComponent(this.relink_basic_button)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label3).addComponent(this.block_size_field)).addComponent(format_top).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(select_format_prg).addComponent(select_format_raw)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(select_format_s20).addComponent(select_format_p00)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(select_format_pcv).addComponent(select_format_sid)).addComponent(select_format_crt).addComponent(format_bot).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ok_button).addComponent(cancel_button)));
        layout.linkSize(0, ok_button, cancel_button);
    }

    private void setFormatButton() {
        JRadioButton button = this.select_file_format.get(this.file_format);
        if (button != null) {
            button.setSelected(true);
        }
    }

    private JRadioButton createFormatSelectButton(String caption, String command, int format, boolean enabled) {
        JRadioButton select_format_button = new JRadioButton(caption);
        select_format_button.setActionCommand(command);
        select_format_button.addActionListener(this);
        select_format_button.setEnabled(enabled);
        this.select_file_format.put(format, select_format_button);
        return select_format_button;
    }

    private JButton createCommandButton(String caption, String command) {
        JButton file_button = new JButton(caption);
        file_button.setActionCommand(command);
        file_button.addActionListener(this);
        return file_button;
    }

    private Integer fetchNumberFromField(JTextField number_field) {
        int number = -1;
        try {
            String num_text = number_field.getText();
            number = AddressRange.addressFromString(num_text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    private void setNumberToField(JTextField number_field, Integer start_address) {
        number_field.setText(start_address < 0 ? "" : start_address.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("browse".equals(e.getActionCommand())) {
            this.onBrowse();
        } else if ("ok".equals(e.getActionCommand())) {
            this.onOk();
        } else if ("cancel".equals(e.getActionCommand())) {
            this.onCancel();
        } else if ("select_raw".equals(e.getActionCommand())) {
            this.onSelectRaw();
        } else if ("select_prg".equals(e.getActionCommand())) {
            this.onSelectPrg();
        } else if ("select_p00".equals(e.getActionCommand())) {
            this.onSelectP00();
        } else if ("select_s20".equals(e.getActionCommand())) {
            this.onSelectS20();
        } else if ("select_pcvic".equals(e.getActionCommand())) {
            this.onSelectPcVic();
        } else if ("select_crt".equals(e.getActionCommand())) {
            this.onSelectCrt();
        } else if ("select_sid".equals(e.getActionCommand())) {
            this.onSelectSid();
        }
    }

    private void selectFileFormat(int new_format) {
        this.file_format = new_format;
        String file_name = this.getFileName();
        if (!this.is_save_dialog && new_format != 0 && file_name != null) {
            FileInfo info = FileHelper.getFileInfo(file_name, this.file_format);
            if (info != null) {
                this.setStartAddress(info.getStartAddress());
                this.setBlockSize(info.getBlockSize());
            } else {
                this.setStartAddress(-1);
                this.setBlockSize(-1);
            }
            this.setFormatButton();
        }
    }

    private void onSelectRaw() {
        this.selectFileFormat(1);
    }

    private void onSelectPrg() {
        this.selectFileFormat(2);
    }

    private void onSelectP00() {
        this.selectFileFormat(5);
    }

    private void onSelectS20() {
        this.selectFileFormat(4);
    }

    private void onSelectPcVic() {
        this.selectFileFormat(3);
    }

    private void onSelectCrt() {
        this.selectFileFormat(6);
    }

    private void onSelectSid() {
        this.selectFileFormat(7);
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void onOk() {
        this.relink_basic = this.relink_basic_button.isSelected();
        this.result_valid = true;
        this.setVisible(false);
    }

    private void onBrowse() {
        String selected_file;
        FileDialog fd = null;
        fd = this.is_save_dialog ? new FileDialog((Dialog)this, "Save Memory to File", 1) : new FileDialog((Dialog)this, "Load Memory from File", 0);
        fd.setVisible(true);
        if (fd.getDirectory() != null && fd.getFile() != null && !(selected_file = String.valueOf(fd.getDirectory()) + fd.getFile()).isEmpty()) {
            this.file_name_field.setText(selected_file);
            int file_format = FileHelper.guessFileFormat(selected_file);
            this.selectFileFormat(file_format);
            if (file_format != 0) {
                this.setFormatButton();
            }
        }
    }
}

