/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.iec.DeviceInfo;
import emulator.hardware.io.peripherals.iec.IecSim;
import emulator.hardware.io.peripherals.iec.IecSimDeviceRegistry;
import emulator.hardware.io.porthistory.PortStateHistory;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.shell.GUI.graph.BitGraph;
import emulator.shell.GUI.menu.GraphWindow;
import emulator.shell.GUI.viewmodel.DeviceTableModel;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class WindowIEC
extends GraphWindow
implements ActionListener,
Observer {
    private int window_id;
    private WindowManager window_manager;
    private ManagedWindow window = null;
    private JTextPane content = null;
    private IecSim iec_sim = null;
    private JCheckBox log_state_button = null;
    private JButton clear_log_button = null;
    private JButton add_device_button = null;
    private JButton del_device_button = null;
    private JTable device_table = null;
    private DeviceTableModel device_table_model = null;
    private PortStateHistory portStateHistory1;
    private PortStateHistory portStateHistory2;
    private Via6522 via;

    public WindowIEC(WindowManager window_manager, int window_id, IecSim iec_sim, Via6522 via, Cpu6502 cpu, PortStateHistory portStateHistory1, PortStateHistory portStateHistory2) {
        this.window_manager = window_manager;
        this.window_id = window_id;
        this.iec_sim = iec_sim;
        this.via = via;
        this.cpu = cpu;
        this.portStateHistory1 = portStateHistory1;
        this.portStateHistory2 = portStateHistory2;
        iec_sim.getId();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.window_manager.isWindowActive(this.window_id)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        this.window = this.window_manager.createWindow(this.window_id, "Debug IEC");
        this.addComponentsToPane(this.window.getContentPane());
        this.window.restorePosition();
        this.window.setVisible(true);
        this.fetchLogLines();
        this.iec_sim.addLogObserver(this);
        this.cpu.addRunningStateObserver(this.cpuObserver);
    }

    private void closeWindow() {
        this.cpu.deleteRunningStateObserver(this.cpuObserver);
        this.iec_sim.deleteLogObserver(this);
        this.window_manager.closeWindow(this.window_id);
    }

    private void addComponentsToPane(Container pane) {
        if (!(pane.getLayout() instanceof BorderLayout)) {
            pane.add(new JLabel("Container doesn't use BorderLayout!"));
            return;
        }
        JPanel device_panel = this.createDevicePanel();
        JPanel log_panel = this.createLogPanel();
        JSplitPane splitPaneLeft = new JSplitPane(0, device_panel, log_panel);
        splitPaneLeft.setOneTouchExpandable(true);
        splitPaneLeft.setDividerLocation(150);
        Dimension minimumSize = new Dimension(100, 50);
        device_panel.setMinimumSize(minimumSize);
        log_panel.setMinimumSize(minimumSize);
        if (this.portStateHistory1 != null && this.portStateHistory2 != null) {
            JSplitPane splitPane = new JSplitPane(1, splitPaneLeft, this.createGraphFrame());
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(splitPaneLeft.getPreferredSize().width);
            pane.add((Component)splitPane, "Center");
        } else {
            pane.add((Component)splitPaneLeft, "Center");
        }
    }

    private JPanel createDevicePanel() {
        JPanel panel_config = new JPanel();
        panel_config.setLayout(new BorderLayout());
        JLabel label = new JLabel("Devices");
        panel_config.add((Component)label, "First");
        this.device_table = new JTable();
        this.device_table_model = new DeviceTableModel();
        this.device_table.setModel(this.device_table_model);
        int i = 0;
        while (i < this.device_table_model.getColumnCount()) {
            TableColumn column = this.device_table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.device_table_model.getColumnWidth(i));
            ++i;
        }
        TableColumn col = this.device_table.getColumnModel().getColumn(2);
        class DeviceTypeCellEditor
        extends DefaultCellEditor {
            DeviceTypeCellEditor() {
                super(new JComboBox<String>(DeviceInfo.getDeviceTypes()));
            }
        }
        col.setCellEditor(new DeviceTypeCellEditor());
        this.device_table.setFillsViewportHeight(true);
        panel_config.add((Component)new JScrollPane(this.device_table), "Center");
        this.add_device_button = new JButton("Add");
        this.add_device_button.addActionListener(new AddDevice());
        this.del_device_button = new JButton("Remove");
        this.del_device_button.addActionListener(new DelDevice());
        JPanel panel = new JPanel();
        panel.add((Component)this.add_device_button, "West");
        panel.add((Component)this.del_device_button, "East");
        panel_config.add((Component)panel, "Last");
        return panel_config;
    }

    private JPanel createLogPanel() {
        JPanel panel_log = new JPanel();
        panel_log.setLayout(new BorderLayout());
        JLabel label = new JLabel("Debug Log");
        panel_log.add((Component)label, "First");
        this.content = new JTextPane();
        this.content.setEditable(false);
        this.content.setPreferredSize(new Dimension(300, 300));
        panel_log.add((Component)new JScrollPane(this.content), "Center");
        this.log_state_button = new JCheckBox("Log state");
        this.log_state_button.addItemListener(new ToggleLogState());
        this.log_state_button.setSelected(this.iec_sim.isStateLogEnabled());
        this.clear_log_button = new JButton("Clear log");
        this.clear_log_button.addActionListener(new ClearLog());
        JPanel panel = new JPanel();
        panel.add((Component)this.log_state_button, "West");
        panel.add((Component)this.clear_log_button, "East");
        panel_log.add((Component)panel, "Last");
        return panel_log;
    }

    @Override
    protected BitGraph createGraph() {
        BitGraph bitGraph = new BitGraph(6);
        bitGraph.getGraphLine(0).setLabel("ATN").setStateHistory(this.portStateHistory1.getPortAout(7)).setPositionIndex(0);
        bitGraph.getGraphLine(1).setLabel("CLK/o").setStateHistory(this.portStateHistory2.getPortActrl(1)).setPositionIndex(1);
        bitGraph.getGraphLine(2).setLabel("DAT/o").setStateHistory(this.portStateHistory2.getPortBctrl(1)).setPositionIndex(3);
        bitGraph.getGraphLine(3).setLabel("CLK/i").setStateHistory(this.portStateHistory1.getPortAin(0)).setPositionIndex(2);
        bitGraph.getGraphLine(4).setLabel("DAT/i").setStateHistory(this.portStateHistory1.getPortAin(1)).setPositionIndex(4);
        bitGraph.getGraphLine(5).setLabel("SRQ").setStateHistory(this.portStateHistory2.getPortBctrl(0)).setPositionIndex(5);
        return bitGraph;
    }

    @Override
    protected void onCpuStoppped() {
    }

    @Override
    protected long getMaxTicks() {
        return this.via.getTicks();
    }

    private void fetchLogLines() {
        Document doc = this.content.getDocument();
        String log_line = this.iec_sim.getLogLine();
        while (log_line != null) {
            try {
                doc.insertString(doc.getLength(), log_line, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            log_line = this.iec_sim.getLogLine();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        SwingUtilities.invokeLater(new LogWriteEvent());
    }

    public class AddDevice
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object[] device_numbers = IecSimDeviceRegistry.instance().getAvailableDeviceNumbers();
            Integer device_number = (Integer)JOptionPane.showInputDialog(WindowIEC.this.window, "Select a device number", "Add Device", -1, null, device_numbers, device_numbers[0]);
            if (device_number != null) {
                DeviceInfo device = new DeviceInfo((int)device_number, device_number < 8 ? 1 : 0, device_number < 8 ? "(null)" : ".");
                IecSimDeviceRegistry.instance().addDevice(device);
                WindowIEC.this.device_table_model.addDevice(device);
            }
        }
    }

    public class ClearLog
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            Document doc = WindowIEC.this.content.getDocument();
            try {
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class DelDevice
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceInfo device;
            int row = WindowIEC.this.device_table.getSelectedRow();
            if (row >= 0 && (device = WindowIEC.this.device_table_model.getDeviceForRow(row)) != null) {
                IecSimDeviceRegistry.instance().removeDevice(device);
                WindowIEC.this.device_table_model.removeDevice(device);
            }
        }
    }

    public class LogWriteEvent
    implements Runnable {
        @Override
        public void run() {
            WindowIEC.this.fetchLogLines();
        }
    }

    public class ToggleLogState
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent event) {
            WindowIEC.this.iec_sim.setStateLogEnabled(WindowIEC.this.log_state_button.isSelected());
        }
    }
}

