/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockImpl2;
import emulator.shell.GUI.windows.ManagedWindow;
import emulator.shell.GUI.windows.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowSettings
implements ActionListener {
    private int _windowId;
    private WindowManager _windowManager;
    private ClockImpl2 _clock;

    public WindowSettings(WindowManager windowManager, int windowId, Clock clock) {
        this._windowManager = windowManager;
        this._windowId = windowId;
        this._clock = (ClockImpl2)clock;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._windowManager.isWindowActive(this._windowId)) {
            this.closeWindow();
        } else {
            this.openWindow();
        }
    }

    private void openWindow() {
        ManagedWindow window = this._windowManager.createWindow(this._windowId, "Settings");
        this.initDialog(window);
        window.restorePosition();
        window.setVisible(true);
    }

    private void closeWindow() {
        this._windowManager.closeWindow(this._windowId);
    }

    private void initDialog(ManagedWindow window) {
        JLabel title = new JLabel("Clock emulation", 0);
        title.setFont(new Font("Arial", 1, 16));
        JLabel leftText = new JLabel("Accuracy");
        JLabel rightText = new JLabel("Speed");
        JSlider sliderThreshhold = new JSlider(0, 0, 10, this._clock.getSyncThreshhold());
        sliderThreshhold.setMajorTickSpacing(5);
        sliderThreshhold.setMinorTickSpacing(1);
        sliderThreshhold.setPaintTicks(true);
        sliderThreshhold.addChangeListener(new ThreshholdChangeListener());
        Container panel = window.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)title, "North");
        panel.add((Component)leftText, "West");
        panel.add((Component)rightText, "East");
        panel.add((Component)sliderThreshhold, "Center");
    }

    public class ThreshholdChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            if (!source.getValueIsAdjusting()) {
                int threshhold = source.getValue();
                if (threshhold < 1) {
                    threshhold = 1;
                }
                WindowSettings.this._clock.setSyncThreshhold(threshhold);
            }
        }
    }
}

