/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.hardware.HwWord;
import emulator.hardware.debug.profiling.CodeSegment;
import emulator.shell.GUI.profiling.CallTableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class CallTableModel
extends AbstractTableModel {
    private static String[] columns = new String[]{"Total cycles", "Cycles", "Hit count", "Avg. Cycles", "Address", "Label"};
    private List<CallTableData> data = new ArrayList<CallTableData>();
    private Map<Integer, CallTableData> addressMap = new HashMap<Integer, CallTableData>();

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).getSumTotalTicks();
            }
            case 1: {
                return this.data.get(rowIndex).getSumTicks();
            }
            case 2: {
                return this.data.get(rowIndex).getHitCount();
            }
            case 3: {
                return this.data.get(rowIndex).getHitCount() > 0 ? this.data.get(rowIndex).getSumTicks() / (long)this.data.get(rowIndex).getHitCount() : 0L;
            }
            case 4: {
                return "$" + new HwWord((long)this.data.get(rowIndex).getEnterAddress());
            }
            case 5: {
                return this.data.get(rowIndex).getLabel();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public void prepareCodeSegment(CodeSegment codeSegment, String label) {
        CallTableData element = new CallTableData();
        element.setEnterAddress(codeSegment.getEnterAddress());
        element.setLabel(label);
        element.setExitAddresses(new LinkedList<Integer>(codeSegment.getExitAddresses()));
        element.setHitCount(codeSegment.getCallCount());
        element.setSumTotalTicks(codeSegment.getSumTicks());
        element.setSumTicks(codeSegment.getSumTicks() - codeSegment.getSubTicks());
        this.addressMap.put(element.getEnterAddress(), element);
    }

    public void processCodeSegment(CodeSegment codeSegment) {
        CallTableData element = this.addressMap.get(codeSegment.getEnterAddress());
        for (CodeSegment calledSegment : codeSegment.getChildren()) {
            CallTableData child = this.addressMap.get(calledSegment.getEnterAddress());
            child.getParents().add(element);
            element.getChildren().add(child);
        }
        this.data.add(element);
    }

    public int getAddressAtRow(int rowIndex) {
        return this.data.get(rowIndex).getEnterAddress();
    }

    public void postProcess() {
        Collections.sort(this.data);
    }
}

