/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.GUI.PersistentFrame;
import emulator.shell.GUI.profiling.CallTreeModelData;
import emulator.shell.GUI.profiling.ProfilingStatisticsPresenter;
import emulator.shell.GUI.profiling.ProfilingStatisticsVM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ProfilingStatisticsView
extends PersistentFrame {
    private ProfilingStatisticsPresenter presenter;
    private ProfilingStatisticsVM viewModel;
    private JTable codeTable;
    private JTable callTable;
    private JTree callTree;

    public ProfilingStatisticsView(String appName, ProfilingStatisticsPresenter presenter) {
        super("Profiling", appName);
        this.presenter = presenter;
    }

    public void initView(ProfilingStatisticsVM viewModel) {
        this.viewModel = viewModel;
        this.codeTable = new JTable();
        this.codeTable.setAutoCreateRowSorter(true);
        this.codeTable.setModel(viewModel.getCodeTableModel());
        this.codeTable.addMouseListener(new CodeTableListener());
        this.callTable = new JTable();
        this.callTable.setAutoCreateRowSorter(true);
        this.callTable.setModel(viewModel.getCallTableModel());
        this.callTable.addMouseListener(new callTableListener());
        this.callTree = new JTree(viewModel.getCallTreeModel());
        this.callTree.addMouseListener(new CallTreeListener());
        this.callTree.setToggleClickCount(5);
        JScrollPane codeList = new JScrollPane(this.codeTable);
        JScrollPane callList = new JScrollPane(this.callTable);
        JScrollPane graphList = new JScrollPane(this.callTree);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Code", codeList);
        tabbedPane.addTab("Calls", callList);
        tabbedPane.addTab("Tree", graphList);
        JButton button = new JButton("Reset & Close");
        button.addActionListener(new ResetAndClose());
        button.setAlignmentX(0.5f);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "Last");
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        super.windowClosing(arg0);
        this.presenter.onCloseView();
    }

    public class CallTreeListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            CallTreeModelData node;
            TreePath clickedPath;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (clickedPath = ProfilingStatisticsView.this.callTree.getPathForLocation(e.getX(), e.getY())) != null && (node = (CallTreeModelData)clickedPath.getLastPathComponent()).getAddress() >= 0) {
                ProfilingStatisticsView.this.presenter.showCode(node.getAddress());
            }
        }
    }

    public class CodeTableListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int rowIndex = ProfilingStatisticsView.this.codeTable.rowAtPoint(e.getPoint());
                int modelRow = ProfilingStatisticsView.this.codeTable.convertRowIndexToModel(rowIndex);
                ProfilingStatisticsView.this.presenter.showCode(ProfilingStatisticsView.this.viewModel.getAddressAtCodeLine(modelRow));
            }
        }
    }

    public class ResetAndClose
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ProfilingStatisticsView.this.presenter.resetStatisticsAndCloseView();
        }
    }

    public class callTableListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int rowIndex = ProfilingStatisticsView.this.callTable.rowAtPoint(e.getPoint());
                int modelRow = ProfilingStatisticsView.this.callTable.convertRowIndexToModel(rowIndex);
                ProfilingStatisticsView.this.presenter.showCode(ProfilingStatisticsView.this.viewModel.getAddressAtCall(modelRow));
            }
        }
    }
}

