/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.windows;

import emulator.shell.GUI.windows.ManagedWindow;
import java.util.HashMap;
import java.util.Observable;

public class WindowManager
extends Observable {
    private HashMap<Integer, ManagedWindow> window_map = new HashMap();
    private String appName;

    public WindowManager(String appName) {
        this.appName = appName;
    }

    public ManagedWindow createWindow(int id, String name) {
        ManagedWindow window = new ManagedWindow(this, name, this.appName);
        window.setID(id);
        this.window_map.put(id, window);
        this.setChanged();
        this.notifyObservers();
        return window;
    }

    public void unregisterWindow(ManagedWindow managedWindow) {
        if (this.window_map.remove(managedWindow.getID()) != null) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isWindowActive(int id) {
        return this.window_map.containsKey(id);
    }

    public void closeWindow(int id) {
        ManagedWindow window = this.window_map.get(id);
        if (window != null) {
            this.unregisterWindow(window);
            window.setVisible(false);
        }
    }

    public String getAppName() {
        return this.appName;
    }
}

