/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.commands;

import emulator.EmulatorException;
import emulator.shell.DebugShell;
import emulator.shell.ShellCommand;

public class Step
implements ShellCommand {
    @Override
    public boolean execute(DebugShell shell, String[] arg) throws EmulatorException {
        boolean step_done = false;
        if (arg.length > 1) {
            if (arg[1].equalsIgnoreCase("out")) {
                shell.getCpu().enableBreakOnReturn(true);
                shell.getCpu().go();
                step_done = true;
            } else if (arg[1].equalsIgnoreCase("over")) {
                shell.getCpu().stepOver();
                step_done = true;
            } else {
                this.printHelp(shell);
                return false;
            }
        }
        if (!step_done) {
            shell.getCpu().step();
        }
        shell.getCpu().waitForHalt();
        shell.getCpu().printState(shell.getOut());
        return false;
    }

    @Override
    public void printHelp(DebugShell shell) {
        shell.getOut().println("command syntax:");
        shell.getOut().println("step      - execute one instruction");
        shell.getOut().println("step out  - continue until after return");
        shell.getOut().println("step over - step over subroutine");
    }
}

