/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class AbsoluteXOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public AbsoluteXOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int reg_x = cpu_state.getValue("X");
        int operand = this.instruction.getWordOp();
        this.instruction.setAddress(operand);
        String result = "($" + new HwWord((long)operand) + " + $" + new HwByte((long)reg_x) + ") -> $" + new HwByte(this.instruction.getByteOp(reg_x));
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        return this.instruction.getWordOp() + cpu_state.getValue("X");
    }

    @Override
    public boolean isIndirect() {
        return false;
    }
}

